/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.autoconfigure.datastore.health;

import com.google.cloud.datastore.Datastore;
import java.util.function.Supplier;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.autoconfigure.health.HealthContributorAutoConfiguration;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.gcp.autoconfigure.datastore.DatastoreProvider;
import org.springframework.cloud.gcp.autoconfigure.datastore.GcpDatastoreAutoConfiguration;
import org.springframework.cloud.gcp.autoconfigure.datastore.health.DatastoreHealthIndicator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={Datastore.class, HealthIndicator.class})
@ConditionalOnBean(value={Datastore.class}, parameterizedContainer={Supplier.class})
@ConditionalOnEnabledHealthIndicator(value="datastore")
@AutoConfigureBefore(value={HealthContributorAutoConfiguration.class})
@AutoConfigureAfter(value={GcpDatastoreAutoConfiguration.class})
public class DatastoreHealthIndicatorAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public HealthIndicator datastoreHealthIndicator(DatastoreProvider datastore) {
        return new DatastoreHealthIndicator(datastore);
    }
}

