/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.autoconfigure.bigquery;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryOptions;
import java.io.IOException;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.gcp.autoconfigure.bigquery.GcpBigQueryProperties;
import org.springframework.cloud.gcp.autoconfigure.core.GcpContextAutoConfiguration;
import org.springframework.cloud.gcp.bigquery.core.BigQueryTemplate;
import org.springframework.cloud.gcp.core.CredentialsSupplier;
import org.springframework.cloud.gcp.core.DefaultCredentialsProvider;
import org.springframework.cloud.gcp.core.GcpProjectIdProvider;
import org.springframework.cloud.gcp.core.UserAgentHeaderProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={GcpContextAutoConfiguration.class})
@ConditionalOnProperty(value={"spring.cloud.gcp.bigquery.enabled"}, matchIfMissing=true)
@ConditionalOnClass(value={BigQuery.class, BigQueryTemplate.class})
@EnableConfigurationProperties(value={GcpBigQueryProperties.class})
public class GcpBigQueryAutoConfiguration {
    private final String projectId;
    private final CredentialsProvider credentialsProvider;
    private final String datasetName;

    GcpBigQueryAutoConfiguration(GcpBigQueryProperties gcpBigQueryProperties, GcpProjectIdProvider projectIdProvider, CredentialsProvider credentialsProvider) throws IOException {
        this.projectId = gcpBigQueryProperties.getProjectId() != null ? gcpBigQueryProperties.getProjectId() : projectIdProvider.getProjectId();
        this.credentialsProvider = gcpBigQueryProperties.getCredentials().hasKey() ? new DefaultCredentialsProvider((CredentialsSupplier)gcpBigQueryProperties) : credentialsProvider;
        this.datasetName = gcpBigQueryProperties.getDatasetName();
    }

    @Bean
    @ConditionalOnMissingBean
    public BigQuery bigQuery() throws IOException {
        BigQueryOptions bigQueryOptions = ((BigQueryOptions.Builder)((BigQueryOptions.Builder)((BigQueryOptions.Builder)BigQueryOptions.newBuilder().setProjectId(this.projectId)).setCredentials(this.credentialsProvider.getCredentials())).setHeaderProvider((HeaderProvider)new UserAgentHeaderProvider(GcpBigQueryAutoConfiguration.class))).build();
        return (BigQuery)bigQueryOptions.getService();
    }

    @Bean
    @ConditionalOnMissingBean
    public BigQueryTemplate bigQueryTemplate(BigQuery bigQuery) {
        return new BigQueryTemplate(bigQuery, this.datasetName);
    }
}

