/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.autoconfigure.firestore;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.auth.Credentials;
import com.google.cloud.firestore.Firestore;
import com.google.cloud.firestore.FirestoreOptions;
import com.google.firestore.v1.FirestoreGrpc;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.auth.MoreCallCredentials;
import java.io.IOException;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.gcp.autoconfigure.core.GcpContextAutoConfiguration;
import org.springframework.cloud.gcp.autoconfigure.firestore.GcpFirestoreProperties;
import org.springframework.cloud.gcp.core.CredentialsSupplier;
import org.springframework.cloud.gcp.core.DefaultCredentialsProvider;
import org.springframework.cloud.gcp.core.GcpProjectIdProvider;
import org.springframework.cloud.gcp.core.UserAgentHeaderProvider;
import org.springframework.cloud.gcp.data.firestore.FirestoreTemplate;
import org.springframework.cloud.gcp.data.firestore.mapping.FirestoreMappingContext;
import org.springframework.cloud.gcp.data.firestore.transaction.ReactiveFirestoreTransactionManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import reactor.core.publisher.Flux;

@Configuration
@AutoConfigureAfter(value={GcpContextAutoConfiguration.class})
@ConditionalOnProperty(value={"spring.cloud.gcp.firestore.enabled"}, matchIfMissing=true)
@ConditionalOnClass(value={Firestore.class})
@EnableConfigurationProperties(value={GcpFirestoreProperties.class})
public class GcpFirestoreAutoConfiguration {
    private static final String ROOT_PATH_FORMAT = "projects/%s/databases/(default)/documents";
    private static final UserAgentHeaderProvider USER_AGENT_HEADER_PROVIDER = new UserAgentHeaderProvider(GcpFirestoreAutoConfiguration.class);
    private final String projectId;
    private final CredentialsProvider credentialsProvider;
    private final String hostPort;
    private final String firestoreRootPath;

    GcpFirestoreAutoConfiguration(GcpFirestoreProperties gcpFirestoreProperties, GcpProjectIdProvider projectIdProvider, CredentialsProvider credentialsProvider) throws IOException {
        this.projectId = gcpFirestoreProperties.getProjectId() != null ? gcpFirestoreProperties.getProjectId() : projectIdProvider.getProjectId();
        this.credentialsProvider = gcpFirestoreProperties.getCredentials().hasKey() ? new DefaultCredentialsProvider((CredentialsSupplier)gcpFirestoreProperties) : credentialsProvider;
        this.hostPort = gcpFirestoreProperties.getHostPort();
        this.firestoreRootPath = String.format(ROOT_PATH_FORMAT, this.projectId);
    }

    @Bean
    @ConditionalOnMissingBean
    public FirestoreOptions firestoreOptions() {
        return ((FirestoreOptions.Builder)((FirestoreOptions.Builder)FirestoreOptions.getDefaultInstance().toBuilder().setCredentialsProvider(this.credentialsProvider).setProjectId(this.projectId)).setHeaderProvider((HeaderProvider)USER_AGENT_HEADER_PROVIDER)).setChannelProvider((TransportChannelProvider)InstantiatingGrpcChannelProvider.newBuilder().setEndpoint(this.hostPort).build()).build();
    }

    @Bean
    @ConditionalOnMissingBean
    public Firestore firestore(FirestoreOptions firestoreOptions) {
        return (Firestore)firestoreOptions.getService();
    }

    @ConditionalOnClass(value={FirestoreGrpc.FirestoreStub.class, Flux.class})
    class FirestoreReactiveAutoConfiguration {
        FirestoreReactiveAutoConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public FirestoreGrpc.FirestoreStub firestoreGrpcStub(ManagedChannel firestoreManagedChannel) throws IOException {
            return (FirestoreGrpc.FirestoreStub)FirestoreGrpc.newStub((Channel)firestoreManagedChannel).withCallCredentials(MoreCallCredentials.from((Credentials)GcpFirestoreAutoConfiguration.this.credentialsProvider.getCredentials()));
        }

        @Bean
        @ConditionalOnMissingBean
        public FirestoreMappingContext firestoreMappingContext() {
            return new FirestoreMappingContext();
        }

        @Bean
        @ConditionalOnMissingBean
        public FirestoreTemplate firestoreTemplate(FirestoreGrpc.FirestoreStub firestoreStub) {
            return new FirestoreTemplate(firestoreStub, GcpFirestoreAutoConfiguration.this.firestoreRootPath);
        }

        @Bean
        @ConditionalOnMissingBean
        public ReactiveFirestoreTransactionManager firestoreTransactionManager(FirestoreGrpc.FirestoreStub firestoreStub) {
            return new ReactiveFirestoreTransactionManager(firestoreStub, GcpFirestoreAutoConfiguration.this.firestoreRootPath);
        }

        @Bean
        @ConditionalOnMissingBean
        public ManagedChannel firestoreManagedChannel() {
            return ManagedChannelBuilder.forTarget((String)GcpFirestoreAutoConfiguration.this.hostPort).userAgent(USER_AGENT_HEADER_PROVIDER.getUserAgent()).build();
        }
    }
}

