/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.autoconfigure.datastore;

import com.google.cloud.datastore.testing.LocalDatastoreHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.gcp.autoconfigure.datastore.EmulatorSettings;
import org.springframework.cloud.gcp.autoconfigure.datastore.GcpDatastoreAutoConfiguration;
import org.springframework.cloud.gcp.autoconfigure.datastore.GcpDatastoreProperties;
import org.springframework.context.SmartLifecycle;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"spring.cloud.gcp.datastore.emulator.enabled"})
@AutoConfigureBefore(value={GcpDatastoreAutoConfiguration.class})
@EnableConfigurationProperties(value={GcpDatastoreProperties.class})
@ConditionalOnMissingBean(value={LocalDatastoreHelper.class})
public class GcpDatastoreEmulatorAutoConfiguration
implements SmartLifecycle {
    private static final Log LOGGER = LogFactory.getLog(GcpDatastoreEmulatorAutoConfiguration.class);
    private LocalDatastoreHelper helper;
    private volatile boolean running;

    @Bean
    public LocalDatastoreHelper createDatastoreHelper(GcpDatastoreProperties datastoreProperties) {
        EmulatorSettings settings = datastoreProperties.getEmulator();
        this.helper = LocalDatastoreHelper.create((double)settings.getConsistency(), (int)settings.getPort());
        return this.helper;
    }

    public void stop() {
        if (!this.isRunning()) {
            LOGGER.warn((Object)"The datastore emulator is not running.");
            return;
        }
        try {
            LOGGER.info((Object)"Stopping datastore emulator.");
            this.helper.stop();
            LOGGER.info((Object)"Datastore emulator stopped.");
            this.running = false;
        }
        catch (Exception e) {
            LOGGER.warn((Object)"Failed to stop datastore instance.", (Throwable)e);
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public void start() {
        if (this.isRunning()) {
            LOGGER.warn((Object)"The datastore emulator is already running.");
            return;
        }
        try {
            LOGGER.info((Object)"Starting datastore emulator.");
            this.helper.start();
            LOGGER.info((Object)"Datastore emulator started.");
            this.running = true;
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error constructing datastore instance.");
        }
    }
}

