/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.autoconfigure.datastore;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.auth.Credentials;
import com.google.cloud.datastore.Datastore;
import com.google.cloud.datastore.DatastoreOptions;
import com.google.cloud.datastore.DatastoreReaderWriter;
import java.io.IOException;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.gcp.autoconfigure.core.GcpContextAutoConfiguration;
import org.springframework.cloud.gcp.autoconfigure.datastore.GcpDatastoreProperties;
import org.springframework.cloud.gcp.core.CredentialsSupplier;
import org.springframework.cloud.gcp.core.DefaultCredentialsProvider;
import org.springframework.cloud.gcp.core.GcpProjectIdProvider;
import org.springframework.cloud.gcp.core.UserAgentHeaderProvider;
import org.springframework.cloud.gcp.data.datastore.core.DatastoreOperations;
import org.springframework.cloud.gcp.data.datastore.core.DatastoreTemplate;
import org.springframework.cloud.gcp.data.datastore.core.convert.DatastoreCustomConversions;
import org.springframework.cloud.gcp.data.datastore.core.convert.DatastoreEntityConverter;
import org.springframework.cloud.gcp.data.datastore.core.convert.DatastoreServiceObjectToKeyFactory;
import org.springframework.cloud.gcp.data.datastore.core.convert.DefaultDatastoreEntityConverter;
import org.springframework.cloud.gcp.data.datastore.core.convert.ObjectToKeyFactory;
import org.springframework.cloud.gcp.data.datastore.core.convert.ReadWriteConversions;
import org.springframework.cloud.gcp.data.datastore.core.convert.TwoStepsConversions;
import org.springframework.cloud.gcp.data.datastore.core.mapping.DatastoreMappingContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.convert.CustomConversions;

@Configuration
@AutoConfigureAfter(value={GcpContextAutoConfiguration.class})
@ConditionalOnProperty(value={"spring.cloud.gcp.datastore.enabled"}, matchIfMissing=true)
@ConditionalOnClass(value={DatastoreOperations.class, Datastore.class})
@EnableConfigurationProperties(value={GcpDatastoreProperties.class})
public class GcpDatastoreAutoConfiguration {
    private final String projectId;
    private final String namespace;
    private final Credentials credentials;

    GcpDatastoreAutoConfiguration(GcpDatastoreProperties gcpDatastoreProperties, GcpProjectIdProvider projectIdProvider, CredentialsProvider credentialsProvider) throws IOException {
        this.credentials = (gcpDatastoreProperties.getCredentials().hasKey() ? new DefaultCredentialsProvider((CredentialsSupplier)gcpDatastoreProperties) : credentialsProvider).getCredentials();
        this.projectId = gcpDatastoreProperties.getProjectId() != null ? gcpDatastoreProperties.getProjectId() : projectIdProvider.getProjectId();
        this.namespace = gcpDatastoreProperties.getNamespace();
    }

    @Bean
    @ConditionalOnMissingBean
    public Datastore datastore() {
        DatastoreOptions.Builder builder = (DatastoreOptions.Builder)((DatastoreOptions.Builder)((DatastoreOptions.Builder)DatastoreOptions.newBuilder().setProjectId(this.projectId)).setHeaderProvider((HeaderProvider)new UserAgentHeaderProvider(this.getClass()))).setCredentials(this.credentials);
        if (this.namespace != null) {
            builder.setNamespace(this.namespace);
        }
        return (Datastore)builder.build().getService();
    }

    @Bean
    @ConditionalOnMissingBean
    public DatastoreCustomConversions datastoreCustomConversions() {
        return new DatastoreCustomConversions();
    }

    @Bean
    @ConditionalOnMissingBean
    public ReadWriteConversions datastoreReadWriteConversions(DatastoreCustomConversions customConversions, ObjectToKeyFactory objectToKeyFactory) {
        return new TwoStepsConversions((CustomConversions)customConversions, objectToKeyFactory);
    }

    @Bean
    @ConditionalOnMissingBean
    public DatastoreMappingContext datastoreMappingContext() {
        return new DatastoreMappingContext();
    }

    @Bean
    @ConditionalOnMissingBean
    public ObjectToKeyFactory objectToKeyFactory(Datastore datastore) {
        return new DatastoreServiceObjectToKeyFactory(datastore);
    }

    @Bean
    @ConditionalOnMissingBean
    public DatastoreEntityConverter datastoreEntityConverter(DatastoreMappingContext datastoreMappingContext, ReadWriteConversions conversions) {
        return new DefaultDatastoreEntityConverter(datastoreMappingContext, conversions);
    }

    @Bean
    @ConditionalOnMissingBean
    public DatastoreTemplate datastoreTemplate(Datastore datastore, DatastoreMappingContext datastoreMappingContext, DatastoreEntityConverter datastoreEntityConverter, ObjectToKeyFactory objectToKeyFactory) {
        return new DatastoreTemplate((DatastoreReaderWriter)datastore, datastoreEntityConverter, datastoreMappingContext, objectToKeyFactory);
    }
}

