/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.actuate;

import java.util.Collections;
import java.util.List;
import java.util.Objects;

class GatewayEndpointInfo {
    private String href;
    private List<String> methods;

    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public String[] getMethods() {
        return (String[])this.methods.stream().toArray(String[]::new);
    }

    GatewayEndpointInfo(String href, String method) {
        this.href = href;
        this.methods = Collections.singletonList(method);
    }

    GatewayEndpointInfo(String href, List<String> methods) {
        this.href = href;
        this.methods = methods;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GatewayEndpointInfo that = (GatewayEndpointInfo)o;
        return Objects.equals(this.href, that.href) && Objects.equals(this.methods, that.methods);
    }

    public int hashCode() {
        return Objects.hash(this.href, this.methods);
    }
}

