/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory.cache.postprocessor;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.gateway.filter.factory.cache.CachedResponse;
import org.springframework.cloud.gateway.filter.factory.cache.postprocessor.AfterCacheExchangeMutator;
import org.springframework.web.server.ServerWebExchange;

public class RemoveHeadersAfterCacheExchangeMutator
implements AfterCacheExchangeMutator {
    private static final Log LOGGER = LogFactory.getLog(RemoveHeadersAfterCacheExchangeMutator.class);
    private final String[] httpHeader;

    public RemoveHeadersAfterCacheExchangeMutator(String ... httpHeaders) {
        this.httpHeader = httpHeaders;
    }

    @Override
    public void accept(ServerWebExchange exchange, CachedResponse cachedResponse) {
        for (String header : this.httpHeader) {
            List previousValue = exchange.getResponse().getHeaders().remove((Object)header);
            if (previousValue == null) continue;
            LOGGER.debug((Object)("HTTP Header value found in response, removing HTTP header " + header));
        }
    }
}

