/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import io.github.resilience4j.circuitbreaker.CallNotPermittedException;
import java.util.concurrent.TimeoutException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.cloud.client.circuitbreaker.ReactiveCircuitBreakerFactory;
import org.springframework.cloud.gateway.filter.factory.SpringCloudCircuitBreakerFilterFactory;
import org.springframework.cloud.gateway.support.ServiceUnavailableException;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.web.reactive.DispatcherHandler;
import org.springframework.web.server.ResponseStatusException;
import reactor.core.publisher.Mono;

public class SpringCloudCircuitBreakerResilience4JFilterFactory
extends SpringCloudCircuitBreakerFilterFactory {
    public SpringCloudCircuitBreakerResilience4JFilterFactory(ReactiveCircuitBreakerFactory reactiveCircuitBreakerFactory, ObjectProvider<DispatcherHandler> dispatcherHandlerProvider) {
        super(reactiveCircuitBreakerFactory, dispatcherHandlerProvider);
    }

    @Override
    protected Mono<Void> handleErrorWithoutFallback(Throwable t, boolean resumeWithoutError) {
        if (TimeoutException.class.isInstance(t)) {
            return Mono.error((Throwable)new ResponseStatusException((HttpStatusCode)HttpStatus.GATEWAY_TIMEOUT, t.getMessage(), t));
        }
        if (CallNotPermittedException.class.isInstance(t)) {
            return Mono.error((Throwable)new ServiceUnavailableException());
        }
        if (resumeWithoutError) {
            return Mono.empty();
        }
        return Mono.error((Throwable)t);
    }
}

