/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.ratelimit;

import java.util.Map;
import org.springframework.cloud.gateway.event.FilterArgsEvent;
import org.springframework.cloud.gateway.filter.ratelimit.RateLimiter;
import org.springframework.cloud.gateway.support.AbstractStatefulConfigurable;
import org.springframework.cloud.gateway.support.ConfigurationService;
import org.springframework.context.ApplicationListener;
import org.springframework.core.style.ToStringCreator;
import org.springframework.validation.Validator;

public abstract class AbstractRateLimiter<C>
extends AbstractStatefulConfigurable<C>
implements RateLimiter<C>,
ApplicationListener<FilterArgsEvent> {
    private String configurationPropertyName;
    private ConfigurationService configurationService;

    @Deprecated
    protected AbstractRateLimiter(Class<C> configClass, String configurationPropertyName, Validator validator) {
        super(configClass);
        this.configurationPropertyName = configurationPropertyName;
        this.configurationService = new ConfigurationService();
        this.configurationService.setValidator(validator);
    }

    protected AbstractRateLimiter(Class<C> configClass, String configurationPropertyName, ConfigurationService configurationService) {
        super(configClass);
        this.configurationPropertyName = configurationPropertyName;
        this.configurationService = configurationService;
    }

    protected String getConfigurationPropertyName() {
        return this.configurationPropertyName;
    }

    @Deprecated
    protected Validator getValidator() {
        if (this.configurationService != null) {
            return this.configurationService.getValidator();
        }
        return null;
    }

    @Deprecated
    public void setValidator(Validator validator) {
        if (this.configurationService != null) {
            this.configurationService.setValidator(validator);
        }
    }

    protected void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public void onApplicationEvent(FilterArgsEvent event) {
        Map<String, Object> args = event.getArgs();
        if (args.isEmpty() || !this.hasRelevantKey(args)) {
            return;
        }
        String routeId = event.getRouteId();
        Object routeConfig = this.newConfig();
        if (this.configurationService != null) {
            ((ConfigurationService.InstanceBuilder)((ConfigurationService.InstanceBuilder)this.configurationService.with(routeConfig).name(this.configurationPropertyName)).normalizedProperties(args)).bind();
        }
        this.getConfig().put(routeId, routeConfig);
    }

    private boolean hasRelevantKey(Map<String, Object> args) {
        return args.keySet().stream().anyMatch(key -> key.startsWith(this.configurationPropertyName + "."));
    }

    @Override
    public String toString() {
        return new ToStringCreator((Object)this).append("configurationPropertyName", (Object)this.configurationPropertyName).append("config", this.getConfig()).append("configClass", this.getConfigClass()).toString();
    }
}

