/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.server.ServerWebExchange;

public class FallbackHeadersGatewayFilterFactory
extends AbstractGatewayFilterFactory<Config> {
    public FallbackHeadersGatewayFilterFactory() {
        super(Config.class);
    }

    @Override
    public List<String> shortcutFieldOrder() {
        return Collections.singletonList("name");
    }

    @Override
    public GatewayFilter apply(Config config) {
        return (exchange, chain) -> {
            ServerWebExchange filteredExchange = Optional.ofNullable(Optional.ofNullable((Throwable)exchange.getAttribute(ServerWebExchangeUtils.HYSTRIX_EXECUTION_EXCEPTION_ATTR)).orElseGet(() -> (Throwable)exchange.getAttribute(ServerWebExchangeUtils.CIRCUITBREAKER_EXECUTION_EXCEPTION_ATTR))).map(executionException -> {
                ServerHttpRequest.Builder requestBuilder = exchange.getRequest().mutate();
                requestBuilder.header(config.executionExceptionTypeHeaderName, new String[]{executionException.getClass().getName()});
                requestBuilder.header(config.executionExceptionMessageHeaderName, new String[]{executionException.getMessage()});
                Optional.ofNullable(ExceptionUtils.getRootCause((Throwable)executionException)).ifPresent(rootCause -> {
                    requestBuilder.header(config.rootCauseExceptionTypeHeaderName, new String[]{rootCause.getClass().getName()});
                    requestBuilder.header(config.rootCauseExceptionMessageHeaderName, new String[]{rootCause.getMessage()});
                });
                return exchange.mutate().request(requestBuilder.build()).build();
            }).orElse(exchange);
            return chain.filter(filteredExchange);
        };
    }

    public static class Config {
        private static final String EXECUTION_EXCEPTION_TYPE = "Execution-Exception-Type";
        private static final String EXECUTION_EXCEPTION_MESSAGE = "Execution-Exception-Message";
        private static final String ROOT_CAUSE_EXCEPTION_TYPE = "Root-Cause-Exception-Type";
        private static final String ROOT_CAUSE_EXCEPTION_MESSAGE = "Root-Cause-Exception-Message";
        private String executionExceptionTypeHeaderName = "Execution-Exception-Type";
        private String executionExceptionMessageHeaderName = "Execution-Exception-Message";
        private String rootCauseExceptionTypeHeaderName = "Root-Cause-Exception-Type";
        private String rootCauseExceptionMessageHeaderName = "Root-Cause-Exception-Message";

        public String getExecutionExceptionTypeHeaderName() {
            return this.executionExceptionTypeHeaderName;
        }

        public void setExecutionExceptionTypeHeaderName(String executionExceptionTypeHeaderName) {
            this.executionExceptionTypeHeaderName = executionExceptionTypeHeaderName;
        }

        public String getExecutionExceptionMessageHeaderName() {
            return this.executionExceptionMessageHeaderName;
        }

        public void setExecutionExceptionMessageHeaderName(String executionExceptionMessageHeaderName) {
            this.executionExceptionMessageHeaderName = executionExceptionMessageHeaderName;
        }

        public String getRootCauseExceptionTypeHeaderName() {
            return this.rootCauseExceptionTypeHeaderName;
        }

        public void setRootCauseExceptionTypeHeaderName(String rootCauseExceptionTypeHeaderName) {
            this.rootCauseExceptionTypeHeaderName = rootCauseExceptionTypeHeaderName;
        }

        public String getCauseExceptionMessageHeaderName() {
            return this.rootCauseExceptionMessageHeaderName;
        }

        public void setCauseExceptionMessageHeaderName(String causeExceptionMessageHeaderName) {
            this.rootCauseExceptionMessageHeaderName = causeExceptionMessageHeaderName;
        }
    }
}

