/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.server.mvc.invoke.reflect;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.springframework.cloud.gateway.server.mvc.invoke.OperationParameter;
import org.springframework.cloud.gateway.server.mvc.invoke.OperationParameters;
import org.springframework.cloud.gateway.server.mvc.invoke.reflect.OperationMethodParameter;
import org.springframework.core.ParameterNameDiscoverer;

class OperationMethodParameters
implements OperationParameters {
    private final List<OperationParameter> operationParameters;

    OperationMethodParameters(Method method, ParameterNameDiscoverer parameterNameDiscoverer) {
        Objects.requireNonNull(method, "Method must not be null");
        Objects.requireNonNull(parameterNameDiscoverer, "ParameterNameDiscoverer must not be null");
        @Nullable String @Nullable [] parameterNames = parameterNameDiscoverer.getParameterNames(method);
        Parameter[] parameters = method.getParameters();
        this.operationParameters = this.getOperationParameters(parameters, parameterNames);
    }

    private List<OperationParameter> getOperationParameters(Parameter[] parameters, @Nullable String @Nullable [] names) {
        ArrayList<OperationMethodParameter> operationParameters = new ArrayList<OperationMethodParameter>(parameters.length);
        Objects.requireNonNull(names, "Parameter names must not be null");
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            Objects.requireNonNull(name, "Parameter name must not be null");
            operationParameters.add(new OperationMethodParameter(name, parameters[i]));
        }
        return Collections.unmodifiableList(operationParameters);
    }

    @Override
    public int getParameterCount() {
        return this.operationParameters.size();
    }

    @Override
    public OperationParameter get(int index) {
        return this.operationParameters.get(index);
    }

    @Override
    public Iterator<OperationParameter> iterator() {
        return this.operationParameters.iterator();
    }

    @Override
    public Stream<OperationParameter> stream() {
        return this.operationParameters.stream();
    }
}

