/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.server.mvc.handler;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.net.URI;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.springframework.cloud.gateway.server.mvc.handler.AbstractGatewayServerResponse;
import org.springframework.cloud.gateway.server.mvc.handler.GatewayEntityResponseBuilder;
import org.springframework.cloud.gateway.server.mvc.handler.GatewayRenderingResponseBuilder;
import org.springframework.cloud.gateway.server.mvc.handler.GatewayStreamingServerResponse;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.CacheControl;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.function.ServerResponse;

class GatewayServerResponseBuilder
implements ServerResponse.BodyBuilder {
    private final HttpStatusCode statusCode;
    private final HttpHeaders headers = new HttpHeaders();
    private final MultiValueMap<String, Cookie> cookies = new LinkedMultiValueMap();

    GatewayServerResponseBuilder(ServerResponse other) {
        Objects.requireNonNull(other, "ServerResponse must not be null");
        this.statusCode = other.statusCode();
        this.headers.addAll(other.headers());
        this.cookies.addAll(other.cookies());
    }

    GatewayServerResponseBuilder(HttpStatusCode status) {
        Objects.requireNonNull(status, "HttpStatusCode must not be null");
        this.statusCode = status;
    }

    public ServerResponse.BodyBuilder header(String headerName, String ... headerValues) {
        for (String headerValue : headerValues) {
            this.headers.add(headerName, headerValue);
        }
        return this;
    }

    public ServerResponse.BodyBuilder headers(Consumer<HttpHeaders> headersConsumer) {
        headersConsumer.accept(this.headers);
        return this;
    }

    public ServerResponse.BodyBuilder cookie(Cookie cookie) {
        Objects.requireNonNull(cookie, "Cookie must not be null");
        this.cookies.add((Object)cookie.getName(), (Object)cookie);
        return this;
    }

    public ServerResponse.BodyBuilder cookies(Consumer<MultiValueMap<String, Cookie>> cookiesConsumer) {
        cookiesConsumer.accept(this.cookies);
        return this;
    }

    public ServerResponse.BodyBuilder allow(HttpMethod ... allowedMethods) {
        this.headers.setAllow(new LinkedHashSet<HttpMethod>(Arrays.asList(allowedMethods)));
        return this;
    }

    public ServerResponse.BodyBuilder allow(Set<HttpMethod> allowedMethods) {
        this.headers.setAllow(allowedMethods);
        return this;
    }

    public ServerResponse.BodyBuilder contentLength(long contentLength) {
        this.headers.setContentLength(contentLength);
        return this;
    }

    public ServerResponse.BodyBuilder contentType(MediaType contentType) {
        this.headers.setContentType(contentType);
        return this;
    }

    public ServerResponse.BodyBuilder eTag(String etag) {
        if (!((String)etag).startsWith("\"") && !((String)etag).startsWith("W/\"")) {
            etag = "\"" + (String)etag;
        }
        if (!((String)etag).endsWith("\"")) {
            etag = (String)etag + "\"";
        }
        this.headers.setETag((String)etag);
        return this;
    }

    public ServerResponse.BodyBuilder lastModified(ZonedDateTime lastModified) {
        this.headers.setLastModified(lastModified);
        return this;
    }

    public ServerResponse.BodyBuilder lastModified(Instant lastModified) {
        this.headers.setLastModified(lastModified);
        return this;
    }

    public ServerResponse.BodyBuilder location(URI location) {
        this.headers.setLocation(location);
        return this;
    }

    public ServerResponse.BodyBuilder cacheControl(CacheControl cacheControl) {
        this.headers.setCacheControl(cacheControl);
        return this;
    }

    public ServerResponse.BodyBuilder varyBy(String ... requestHeaders) {
        this.headers.setVary(Arrays.asList(requestHeaders));
        return this;
    }

    public ServerResponse build() {
        return this.build((request, response) -> null);
    }

    public ServerResponse build(ServerResponse.HeadersBuilder.WriteFunction writeFunction) {
        return new WriteFunctionResponse(this.statusCode, this.headers, this.cookies, writeFunction);
    }

    public ServerResponse body(Object body) {
        return GatewayEntityResponseBuilder.fromObject(body).status(this.statusCode).headers(headers -> headers.putAll(this.headers)).cookies(cookies -> cookies.addAll(this.cookies)).build();
    }

    public <T> ServerResponse body(T body, ParameterizedTypeReference<T> bodyType) {
        return GatewayEntityResponseBuilder.fromObject(body, bodyType).status(this.statusCode).headers(headers -> headers.putAll(this.headers)).cookies(cookies -> cookies.addAll(this.cookies)).build();
    }

    public ServerResponse render(String name, Object ... modelAttributes) {
        return new GatewayRenderingResponseBuilder(name).status(this.statusCode).headers(headers -> headers.putAll(this.headers)).cookies(cookies -> cookies.addAll(this.cookies)).modelAttributes(modelAttributes).build();
    }

    public ServerResponse render(String name, Map<String, ?> model) {
        return new GatewayRenderingResponseBuilder(name).status(this.statusCode).headers(headers -> headers.putAll(this.headers)).cookies(cookies -> cookies.addAll(this.cookies)).modelAttributes(model).build();
    }

    public ServerResponse stream(Consumer<ServerResponse.StreamBuilder> streamConsumer) {
        return GatewayStreamingServerResponse.create(this.statusCode, this.headers, this.cookies, streamConsumer, null);
    }

    private static class WriteFunctionResponse
    extends AbstractGatewayServerResponse {
        private final ServerResponse.HeadersBuilder.WriteFunction writeFunction;

        WriteFunctionResponse(HttpStatusCode statusCode, HttpHeaders headers, MultiValueMap<String, Cookie> cookies, ServerResponse.HeadersBuilder.WriteFunction writeFunction) {
            super(statusCode, headers, cookies);
            Objects.requireNonNull(writeFunction, "WriteFunction must not be null");
            this.writeFunction = writeFunction;
        }

        @Override
        protected @Nullable ModelAndView writeToInternal(HttpServletRequest request, HttpServletResponse response, ServerResponse.Context context) throws Exception {
            return this.writeFunction.write(request, response);
        }
    }
}

