/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.server.mvc.filter;

import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;
import org.springframework.web.servlet.function.ServerRequest;
import org.springframework.web.servlet.function.ServerResponse;

public abstract class RewriteLocationResponseHeaderFilterFunctions {
    private static final Pattern VERSIONED_PATH = Pattern.compile("^/v\\d+/.*");
    private static final String DEFAULT_PROTOCOLS = "https?|ftps?";
    private static final Pattern DEFAULT_HOST_PORT = RewriteLocationResponseHeaderFilterFunctions.compileHostPortPattern("https?|ftps?");
    private static final Pattern DEFAULT_HOST_PORT_VERSION = RewriteLocationResponseHeaderFilterFunctions.compileHostPortVersionPattern("https?|ftps?");

    private RewriteLocationResponseHeaderFilterFunctions() {
    }

    private static Pattern compileHostPortPattern(String protocols) {
        return Pattern.compile("(?<=^(?:" + protocols + ")://)[^:/]+(?::\\d+)?(?=/)");
    }

    private static Pattern compileHostPortVersionPattern(String protocols) {
        return Pattern.compile("(?<=^(?:" + protocols + ")://)[^:/]+(?::\\d+)?(?:/v\\d+)?(?=/)");
    }

    public static BiFunction<ServerRequest, ServerResponse, ServerResponse> rewriteLocationResponseHeader(Consumer<RewriteLocationResponseHeaderConfig> configConsumer) {
        RewriteLocationResponseHeaderConfig config = new RewriteLocationResponseHeaderConfig();
        configConsumer.accept(config);
        return (request, response) -> {
            String location = response.headers().getFirst(config.getLocationHeaderName());
            String host = config.getHostValue() != null ? config.getHostValue() : request.headers().firstHeader("Host");
            String path = request.uri().getPath();
            if (location != null && host != null) {
                String fixedLocation = RewriteLocationResponseHeaderFilterFunctions.fixedLocation(location, host, path, config.getStripVersion(), config.getHostPortPattern(), config.getHostPortVersionPattern());
                response.headers().set(config.getLocationHeaderName(), fixedLocation);
            }
            return response;
        };
    }

    private static String fixedLocation(String location, String host, String path, StripVersion stripVersion, Pattern hostPortPattern, Pattern hostPortVersionPattern) {
        boolean doStrip = StripVersion.ALWAYS_STRIP.equals((Object)stripVersion) || StripVersion.AS_IN_REQUEST.equals((Object)stripVersion) && !VERSIONED_PATH.matcher(path).matches();
        Pattern pattern = doStrip ? hostPortVersionPattern : hostPortPattern;
        return pattern.matcher(location).replaceFirst(host);
    }

    public static class RewriteLocationResponseHeaderConfig {
        private StripVersion stripVersion = StripVersion.AS_IN_REQUEST;
        private String locationHeaderName = "Location";
        private @Nullable String hostValue;
        private String protocolsRegex = "https?|ftps?";
        private Pattern hostPortPattern = DEFAULT_HOST_PORT;
        private Pattern hostPortVersionPattern = DEFAULT_HOST_PORT_VERSION;

        public StripVersion getStripVersion() {
            return this.stripVersion;
        }

        public RewriteLocationResponseHeaderConfig setStripVersion(String stripVersion) {
            this.stripVersion = StripVersion.valueOf(stripVersion);
            return this;
        }

        public RewriteLocationResponseHeaderConfig setStripVersion(StripVersion stripVersion) {
            this.stripVersion = stripVersion;
            return this;
        }

        public String getLocationHeaderName() {
            return this.locationHeaderName;
        }

        public RewriteLocationResponseHeaderConfig setLocationHeaderName(String locationHeaderName) {
            this.locationHeaderName = locationHeaderName;
            return this;
        }

        public @Nullable String getHostValue() {
            return this.hostValue;
        }

        public RewriteLocationResponseHeaderConfig setHostValue(String hostValue) {
            this.hostValue = hostValue;
            return this;
        }

        public String getProtocolsRegex() {
            return this.protocolsRegex;
        }

        public RewriteLocationResponseHeaderConfig setProtocolsRegex(String protocolsRegex) {
            this.protocolsRegex = protocolsRegex;
            this.hostPortPattern = RewriteLocationResponseHeaderFilterFunctions.compileHostPortPattern(protocolsRegex);
            this.hostPortVersionPattern = RewriteLocationResponseHeaderFilterFunctions.compileHostPortVersionPattern(protocolsRegex);
            return this;
        }

        public Pattern getHostPortPattern() {
            return this.hostPortPattern;
        }

        public Pattern getHostPortVersionPattern() {
            return this.hostPortVersionPattern;
        }
    }

    public static enum StripVersion {
        NEVER_STRIP,
        AS_IN_REQUEST,
        ALWAYS_STRIP;

    }
}

