/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.server.mvc.config;

import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.springframework.aop.scope.ScopedProxyUtils;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.web.servlet.function.HandlerFilterFunction;
import org.springframework.web.servlet.function.HandlerFunction;
import org.springframework.web.servlet.function.RequestPredicate;
import org.springframework.web.servlet.function.RouterFunction;
import org.springframework.web.servlet.function.RouterFunctions;
import org.springframework.web.servlet.function.ServerRequest;
import org.springframework.web.servlet.function.ServerResponse;

public class GatewayMvcPropertiesBeanDefinitionRegistrar
implements ImportBeanDefinitionRegistrar {
    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        AbstractBeanDefinition routerFnProviderBeanDefinition = BeanDefinitionBuilder.rootBeanDefinition(RouterFunctionHolder.class).setFactoryMethodOnBean("routerFunctionHolderSupplier", "routerFunctionHolderFactory").getBeanDefinition();
        BeanDefinitionHolder holder = new BeanDefinitionHolder((BeanDefinition)routerFnProviderBeanDefinition, "gatewayRouterFunctionHolder");
        BeanDefinitionHolder proxy = ScopedProxyUtils.createScopedProxy((BeanDefinitionHolder)holder, (BeanDefinitionRegistry)registry, (boolean)true);
        if (registry.containsBeanDefinition("refreshScope")) {
            routerFnProviderBeanDefinition.setScope("refresh");
        }
        if (registry.containsBeanDefinition(proxy.getBeanName())) {
            registry.removeBeanDefinition(proxy.getBeanName());
        }
        registry.registerBeanDefinition(proxy.getBeanName(), proxy.getBeanDefinition());
        AbstractBeanDefinition routerFunctionBeanDefinition = BeanDefinitionBuilder.genericBeanDefinition(DelegatingRouterFunction.class).getBeanDefinition();
        registry.registerBeanDefinition("gatewayCompositeRouterFunction", (BeanDefinition)routerFunctionBeanDefinition);
    }

    public static class RouterFunctionHolder {
        private final RouterFunction<ServerResponse> routerFunction;

        public RouterFunctionHolder(RouterFunction<ServerResponse> routerFunction) {
            this.routerFunction = routerFunction;
        }

        public RouterFunction<ServerResponse> getRouterFunction() {
            return this.routerFunction;
        }
    }

    static class DelegatingRouterFunction
    implements RouterFunction<ServerResponse> {
        final RouterFunctionHolder provider;

        DelegatingRouterFunction(RouterFunctionHolder provider) {
            this.provider = provider;
        }

        public RouterFunction<ServerResponse> and(RouterFunction<ServerResponse> other) {
            return this.provider.getRouterFunction().and(other);
        }

        public RouterFunction<?> andOther(RouterFunction<?> other) {
            return this.provider.getRouterFunction().andOther(other);
        }

        public RouterFunction<ServerResponse> andRoute(RequestPredicate predicate, HandlerFunction<ServerResponse> handlerFunction) {
            return this.provider.getRouterFunction().andRoute(predicate, handlerFunction);
        }

        public RouterFunction<ServerResponse> andNest(RequestPredicate predicate, RouterFunction<ServerResponse> routerFunction) {
            return this.provider.getRouterFunction().andNest(predicate, routerFunction);
        }

        public <S extends ServerResponse> RouterFunction<S> filter(HandlerFilterFunction<ServerResponse, S> filterFunction) {
            return this.provider.getRouterFunction().filter(filterFunction);
        }

        public void accept(RouterFunctions.Visitor visitor) {
            this.provider.getRouterFunction().accept(visitor);
        }

        public RouterFunction<ServerResponse> withAttribute(String name, Object value) {
            return this.provider.getRouterFunction().withAttribute(name, value);
        }

        public RouterFunction<ServerResponse> withAttributes(Consumer<Map<String, Object>> attributesConsumer) {
            return this.provider.getRouterFunction().withAttributes(attributesConsumer);
        }

        public Optional<HandlerFunction<ServerResponse>> route(ServerRequest request) {
            return this.provider.getRouterFunction().route(request);
        }

        public String toString() {
            return this.provider.getRouterFunction().toString();
        }
    }
}

