/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.server.mvc.handler;

import java.net.URI;
import java.time.Duration;
import org.springframework.cloud.gateway.server.mvc.handler.GatewayAsyncServerResponse;
import org.springframework.cloud.gateway.server.mvc.handler.GatewayServerResponseBuilder;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.web.ErrorResponse;
import org.springframework.web.servlet.function.ServerResponse;

public interface GatewayServerResponse
extends ServerResponse {
    public void setStatusCode(HttpStatusCode var1);

    public static ServerResponse.BodyBuilder from(ServerResponse other) {
        return new GatewayServerResponseBuilder(other);
    }

    public static ServerResponse from(ErrorResponse response) {
        return ((ServerResponse.BodyBuilder)GatewayServerResponse.status(response.getStatusCode()).headers(headers -> headers.putAll(response.getHeaders()))).body((Object)response.getBody());
    }

    public static ServerResponse.BodyBuilder status(HttpStatusCode status) {
        return new GatewayServerResponseBuilder(status);
    }

    public static ServerResponse.BodyBuilder status(int status) {
        return new GatewayServerResponseBuilder(HttpStatusCode.valueOf((int)status));
    }

    public static ServerResponse.BodyBuilder ok() {
        return GatewayServerResponse.status((HttpStatusCode)HttpStatus.OK);
    }

    public static ServerResponse.BodyBuilder created(URI location) {
        ServerResponse.BodyBuilder builder = GatewayServerResponse.status((HttpStatusCode)HttpStatus.CREATED);
        return (ServerResponse.BodyBuilder)builder.location(location);
    }

    public static ServerResponse.BodyBuilder accepted() {
        return GatewayServerResponse.status((HttpStatusCode)HttpStatus.ACCEPTED);
    }

    public static ServerResponse.HeadersBuilder<?> noContent() {
        return GatewayServerResponse.status((HttpStatusCode)HttpStatus.NO_CONTENT);
    }

    public static ServerResponse.BodyBuilder seeOther(URI location) {
        ServerResponse.BodyBuilder builder = GatewayServerResponse.status((HttpStatusCode)HttpStatus.SEE_OTHER);
        return (ServerResponse.BodyBuilder)builder.location(location);
    }

    public static ServerResponse.BodyBuilder temporaryRedirect(URI location) {
        ServerResponse.BodyBuilder builder = GatewayServerResponse.status((HttpStatusCode)HttpStatus.TEMPORARY_REDIRECT);
        return (ServerResponse.BodyBuilder)builder.location(location);
    }

    public static ServerResponse.BodyBuilder permanentRedirect(URI location) {
        ServerResponse.BodyBuilder builder = GatewayServerResponse.status((HttpStatusCode)HttpStatus.PERMANENT_REDIRECT);
        return (ServerResponse.BodyBuilder)builder.location(location);
    }

    public static ServerResponse.BodyBuilder badRequest() {
        return GatewayServerResponse.status((HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    public static ServerResponse.HeadersBuilder<?> notFound() {
        return GatewayServerResponse.status((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    public static ServerResponse.BodyBuilder unprocessableEntity() {
        return GatewayServerResponse.status((HttpStatusCode)HttpStatus.UNPROCESSABLE_ENTITY);
    }

    public static ServerResponse async(Object asyncResponse) {
        return GatewayAsyncServerResponse.create(asyncResponse, null);
    }

    public static ServerResponse async(Object asyncResponse, Duration timeout) {
        return GatewayAsyncServerResponse.create(asyncResponse, timeout);
    }
}

