/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.handler.predicate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.webflux.autoconfigure.WebFluxProperties;
import org.springframework.cloud.gateway.handler.predicate.AbstractRoutePredicateFactory;
import org.springframework.cloud.gateway.handler.predicate.GatewayPredicate;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.cloud.gateway.support.ShortcutConfigurable;
import org.springframework.core.style.ToStringCreator;
import org.springframework.http.server.PathContainer;
import org.springframework.util.StringUtils;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.pattern.PathPattern;
import org.springframework.web.util.pattern.PathPatternParser;

public class PathRoutePredicateFactory
extends AbstractRoutePredicateFactory<Config> {
    private static final Log log = LogFactory.getLog(PathRoutePredicateFactory.class);
    private static final String MATCH_TRAILING_SLASH = "matchTrailingSlash";
    private PathPatternParser pathPatternParser = new PathPatternParser();
    private final WebFluxProperties webFluxProperties;

    public PathRoutePredicateFactory(WebFluxProperties webFluxProperties) {
        super(Config.class);
        this.webFluxProperties = webFluxProperties;
    }

    private static void traceMatch(String prefix, Object desired, Object actual, boolean match) {
        if (log.isTraceEnabled()) {
            String message = String.format("%s \"%s\" %s against value \"%s\"", prefix, desired, match ? "matches" : "does not match", actual);
            log.trace((Object)message);
        }
    }

    public void setPathPatternParser(PathPatternParser pathPatternParser) {
        this.pathPatternParser = pathPatternParser;
    }

    @Override
    public List<String> shortcutFieldOrder() {
        return Arrays.asList("patterns", MATCH_TRAILING_SLASH);
    }

    @Override
    public ShortcutConfigurable.ShortcutType shortcutType() {
        return ShortcutConfigurable.ShortcutType.GATHER_LIST_TAIL_FLAG;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Predicate<ServerWebExchange> apply(final Config config) {
        final ArrayList pathPatterns = new ArrayList();
        PathPatternParser pathPatternParser = this.pathPatternParser;
        synchronized (pathPatternParser) {
            config.getPatterns().forEach(pattern -> {
                Object basePath = this.webFluxProperties.getBasePath();
                boolean basePathIsNotBlank = StringUtils.hasText((String)basePath);
                Object pathPatternStr = pattern;
                if (basePathIsNotBlank) {
                    if (pattern.length() > 1 && !pattern.startsWith("/")) {
                        basePath = (String)basePath + "/";
                    }
                    pathPatternStr = (String)basePath + pattern;
                }
                PathPattern pathPattern = this.pathPatternParser.parse((String)pathPatternStr);
                pathPatterns.add(pathPattern);
            });
        }
        return new GatewayPredicate(){
            final /* synthetic */ PathRoutePredicateFactory this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean test(ServerWebExchange exchange) {
                PathContainer path = (PathContainer)exchange.getAttributes().computeIfAbsent(ServerWebExchangeUtils.GATEWAY_PREDICATE_PATH_CONTAINER_ATTR, s -> PathContainer.parsePath((String)exchange.getRequest().getURI().getRawPath()));
                PathPattern match = null;
                for (int i = 0; i < pathPatterns.size(); ++i) {
                    PathPattern pathPattern = (PathPattern)pathPatterns.get(i);
                    if (!pathPattern.matches(path)) continue;
                    match = pathPattern;
                    break;
                }
                if (match != null) {
                    PathRoutePredicateFactory.traceMatch("Pattern", match.getPatternString(), path, true);
                    PathPattern.PathMatchInfo pathMatchInfo = match.matchAndExtract(path);
                    if (pathMatchInfo != null) {
                        ServerWebExchangeUtils.putUriTemplateVariables(exchange, pathMatchInfo.getUriVariables());
                    }
                    exchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_PREDICATE_MATCHED_PATH_ATTR, match.getPatternString());
                    String routeId = (String)exchange.getAttributes().get(ServerWebExchangeUtils.GATEWAY_PREDICATE_ROUTE_ATTR);
                    if (routeId != null) {
                        exchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_PREDICATE_MATCHED_PATH_ROUTE_ID_ATTR, routeId);
                    }
                    return true;
                }
                PathRoutePredicateFactory.traceMatch("Pattern", config.getPatterns(), path, false);
                return false;
            }

            @Override
            public Object getConfig() {
                return config;
            }

            public String toString() {
                return String.format("Paths: %s, match trailing slash: %b", config.getPatterns(), config.isMatchTrailingSlash());
            }
        };
    }

    public static class Config {
        private List<String> patterns = new ArrayList<String>();
        private boolean matchTrailingSlash = true;

        public List<String> getPatterns() {
            return this.patterns;
        }

        public Config setPatterns(List<String> patterns) {
            this.patterns = patterns;
            return this;
        }

        public boolean isMatchTrailingSlash() {
            return this.matchTrailingSlash;
        }

        public Config setMatchTrailingSlash(boolean matchTrailingSlash) {
            this.matchTrailingSlash = matchTrailingSlash;
            return this;
        }

        public String toString() {
            return new ToStringCreator((Object)this).append("patterns", this.patterns).append(PathRoutePredicateFactory.MATCH_TRAILING_SLASH, this.matchTrailingSlash).toString();
        }
    }
}

