/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.route;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.gateway.config.GatewayProperties;
import org.springframework.cloud.gateway.event.FilterArgsEvent;
import org.springframework.cloud.gateway.event.PredicateArgsEvent;
import org.springframework.cloud.gateway.filter.FilterDefinition;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.OrderedGatewayFilter;
import org.springframework.cloud.gateway.filter.factory.GatewayFilterFactory;
import org.springframework.cloud.gateway.handler.AsyncPredicate;
import org.springframework.cloud.gateway.handler.predicate.PredicateDefinition;
import org.springframework.cloud.gateway.handler.predicate.RoutePredicateFactory;
import org.springframework.cloud.gateway.route.Route;
import org.springframework.cloud.gateway.route.RouteDefinition;
import org.springframework.cloud.gateway.route.RouteDefinitionLocator;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.cloud.gateway.support.ConfigurationService;
import org.springframework.cloud.gateway.support.HasRouteId;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.util.CollectionUtils;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;

public class RouteDefinitionRouteLocator
implements RouteLocator {
    public static final String DEFAULT_FILTERS = "defaultFilters";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final RouteDefinitionLocator routeDefinitionLocator;
    private final ConfigurationService configurationService;
    private final Map<String, RoutePredicateFactory> predicates = new LinkedHashMap<String, RoutePredicateFactory>();
    private final Map<String, GatewayFilterFactory> gatewayFilterFactories = new HashMap<String, GatewayFilterFactory>();
    private final GatewayProperties gatewayProperties;

    public RouteDefinitionRouteLocator(RouteDefinitionLocator routeDefinitionLocator, List<RoutePredicateFactory> predicates, List<GatewayFilterFactory> gatewayFilterFactories, GatewayProperties gatewayProperties, ConfigurationService configurationService) {
        this.routeDefinitionLocator = routeDefinitionLocator;
        this.configurationService = configurationService;
        this.initFactories(predicates);
        gatewayFilterFactories.forEach(factory -> this.gatewayFilterFactories.put(factory.name(), (GatewayFilterFactory)factory));
        this.gatewayProperties = gatewayProperties;
    }

    private void initFactories(List<RoutePredicateFactory> predicates) {
        predicates.forEach(factory -> {
            String key = factory.name();
            if (this.predicates.containsKey(key)) {
                this.logger.warn((Object)("A RoutePredicateFactory named " + key + " already exists, class: " + String.valueOf(this.predicates.get(key)) + ". It will be overwritten."));
            }
            this.predicates.put(key, (RoutePredicateFactory)factory);
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Loaded RoutePredicateFactory [" + key + "]"));
            }
        });
    }

    @Override
    public Flux<Route> getRoutesByMetadata(Map<String, Object> metadata) {
        return this.getRoutes((Flux<RouteDefinition>)this.routeDefinitionLocator.getRouteDefinitions().filter(routeDef -> RouteLocator.matchMetadata(routeDef.getMetadata(), metadata)));
    }

    @Override
    public Flux<Route> getRoutes() {
        return this.getRoutes(this.routeDefinitionLocator.getRouteDefinitions());
    }

    private Flux<Route> getRoutes(Flux<RouteDefinition> routeDefinitions) {
        Flux routes = routeDefinitions.map(this::convertToRoute);
        if (!this.gatewayProperties.isFailOnRouteDefinitionError()) {
            routes = routes.onErrorContinue((error, obj) -> {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn((Object)("RouteDefinition id " + ((RouteDefinition)obj).getId() + " will be ignored. Definition has invalid configs, " + error.getMessage()));
                }
            });
        }
        return routes.map(route -> {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("RouteDefinition matched: " + route.getId()));
            }
            return route;
        });
    }

    private Route convertToRoute(RouteDefinition routeDefinition) {
        AsyncPredicate<ServerWebExchange> predicate = this.combinePredicates(routeDefinition);
        List<GatewayFilter> gatewayFilters = this.getFilters(routeDefinition);
        return ((Route.AsyncBuilder)Route.async(routeDefinition).asyncPredicate(predicate).replaceFilters(gatewayFilters)).build();
    }

    List<GatewayFilter> loadGatewayFilters(String id, List<FilterDefinition> filterDefinitions) {
        ArrayList<GatewayFilter> ordered = new ArrayList<GatewayFilter>(filterDefinitions.size());
        for (int i = 0; i < filterDefinitions.size(); ++i) {
            GatewayFilter gatewayFilter;
            Object configuration;
            FilterDefinition definition = filterDefinitions.get(i);
            GatewayFilterFactory factory = this.gatewayFilterFactories.get(definition.getName());
            if (factory == null) {
                throw new IllegalArgumentException("Unable to find GatewayFilterFactory with name " + definition.getName());
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("RouteDefinition " + id + " applying filter " + String.valueOf(definition.getArgs()) + " to " + definition.getName()));
            }
            if ((configuration = ((ConfigurationService.AbstractBuilder)((ConfigurationService.AbstractBuilder)((ConfigurationService.AbstractBuilder)this.configurationService.with(factory).name(definition.getName())).properties(definition.getArgs())).eventFunction((bound, properties) -> new FilterArgsEvent(this, id, (Map)properties))).bind()) instanceof HasRouteId) {
                HasRouteId hasRouteId = (HasRouteId)configuration;
                hasRouteId.setRouteId(id);
            }
            if ((gatewayFilter = factory.apply(configuration)) instanceof Ordered) {
                ordered.add(gatewayFilter);
                continue;
            }
            ordered.add(new OrderedGatewayFilter(gatewayFilter, i + 1));
        }
        return ordered;
    }

    private List<GatewayFilter> getFilters(RouteDefinition routeDefinition) {
        List<FilterDefinition> definitionFilters;
        ArrayList<GatewayFilter> filters = new ArrayList<GatewayFilter>();
        if (!this.gatewayProperties.getDefaultFilters().isEmpty()) {
            filters.addAll(this.loadGatewayFilters(routeDefinition.getId(), new ArrayList<FilterDefinition>(this.gatewayProperties.getDefaultFilters())));
        }
        if (!CollectionUtils.isEmpty(definitionFilters = routeDefinition.getFilters())) {
            filters.addAll(this.loadGatewayFilters(routeDefinition.getId(), definitionFilters));
        }
        AnnotationAwareOrderComparator.sort(filters);
        return filters;
    }

    private AsyncPredicate<ServerWebExchange> combinePredicates(RouteDefinition routeDefinition) {
        List<PredicateDefinition> predicates = routeDefinition.getPredicates();
        if (predicates == null || predicates.isEmpty()) {
            return AsyncPredicate.from(exchange -> true);
        }
        return predicates.stream().map(nextPredicate -> this.lookup(routeDefinition, (PredicateDefinition)nextPredicate)).reduce(AsyncPredicate.from(exchange -> true), AsyncPredicate::and);
    }

    private AsyncPredicate<ServerWebExchange> lookup(RouteDefinition route, PredicateDefinition predicate) {
        RoutePredicateFactory factory = this.predicates.get(predicate.getName());
        if (factory == null) {
            throw new IllegalArgumentException("Unable to find RoutePredicateFactory with name " + predicate.getName());
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("RouteDefinition " + route.getId() + " applying " + String.valueOf(predicate.getArgs()) + " to " + predicate.getName()));
        }
        Object config = ((ConfigurationService.ConfigurableBuilder)((ConfigurationService.ConfigurableBuilder)((ConfigurationService.ConfigurableBuilder)this.configurationService.with(factory).name(predicate.getName())).properties(predicate.getArgs())).eventFunction((bound, properties) -> new PredicateArgsEvent(this, route.getId(), (Map<String, Object>)properties))).bind();
        return factory.applyAsync(config);
    }
}

