/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.cloud.gateway.support.GatewayToStringStyler;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.UriTemplate;
import reactor.core.publisher.Mono;

public class SetPathGatewayFilterFactory
extends AbstractGatewayFilterFactory<Config> {
    public static final String TEMPLATE_KEY = "template";

    public SetPathGatewayFilterFactory() {
        super(Config.class);
    }

    @Override
    public List<String> shortcutFieldOrder() {
        return Arrays.asList(TEMPLATE_KEY);
    }

    @Override
    public GatewayFilter apply(final Config config) {
        final UriTemplate uriTemplate = new UriTemplate(config.template);
        return new GatewayFilter(){
            final /* synthetic */ SetPathGatewayFilterFactory this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
                ServerHttpRequest req = exchange.getRequest();
                ServerWebExchangeUtils.addOriginalRequestUrl(exchange, req.getURI());
                Map<String, String> uriVariables = ServerWebExchangeUtils.getUriTemplateVariables(exchange);
                URI uri = uriTemplate.expand(uriVariables);
                String newPath = uri.getRawPath();
                exchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR, uri);
                ServerHttpRequest request = req.mutate().path(newPath).build();
                return chain.filter(exchange.mutate().request(request).build());
            }

            public String toString() {
                return GatewayToStringStyler.filterToStringCreator(this.this$0).append(SetPathGatewayFilterFactory.TEMPLATE_KEY, (Object)config.getTemplate()).toString();
            }
        };
    }

    public static class Config {
        private String template;

        public String getTemplate() {
            return this.template;
        }

        public void setTemplate(String template) {
            this.template = template;
        }
    }
}

