/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.config;

import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.webflux.autoconfigure.HttpHandlerAutoConfiguration;
import org.springframework.cloud.gateway.config.GatewayAutoConfiguration;
import org.springframework.cloud.gateway.config.conditional.ConditionalOnEnabledGlobalFilter;
import org.springframework.cloud.gateway.filter.StreamRoutingFilter;
import org.springframework.cloud.stream.config.BindingServiceConfiguration;
import org.springframework.cloud.stream.function.StreamBridge;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.codec.ServerCodecConfigurer;
import org.springframework.web.reactive.DispatcherHandler;

@Configuration(proxyBeanMethods=false)
@AutoConfigureAfter(value={BindingServiceConfiguration.class})
@AutoConfigureBefore(value={HttpHandlerAutoConfiguration.class, GatewayAutoConfiguration.class})
@ConditionalOnClass(value={StreamBridge.class, DispatcherHandler.class})
@ConditionalOnProperty(name={"spring.cloud.gateway.server.webflux.stream.enabled"}, matchIfMissing=true)
class GatewayStreamAutoConfiguration {
    GatewayStreamAutoConfiguration() {
    }

    @Bean
    @ConditionalOnEnabledGlobalFilter
    @ConditionalOnBean(value={StreamBridge.class})
    public StreamRoutingFilter streamRoutingFilter(StreamBridge streamBridge, ServerCodecConfigurer codecConfigurer) {
        return new StreamRoutingFilter(streamBridge, codecConfigurer.getReaders());
    }
}

