/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.cloud.gateway.support.GatewayToStringStyler;
import org.springframework.cloud.gateway.support.HttpStatusHolder;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

public class RedirectToGatewayFilterFactory
extends AbstractGatewayFilterFactory<Config> {
    public static final String STATUS_KEY = "status";
    public static final String URL_KEY = "url";
    public static final String INCLUDE_REQUEST_PARAMS_KEY = "includeRequestParams";

    public RedirectToGatewayFilterFactory() {
        super(Config.class);
    }

    @Override
    public List<String> shortcutFieldOrder() {
        return Arrays.asList(STATUS_KEY, URL_KEY, INCLUDE_REQUEST_PARAMS_KEY);
    }

    @Override
    public GatewayFilter apply(Config config) {
        return this.apply(config.status, config.url, config.includeRequestParams);
    }

    @Override
    public GatewayFilter apply(String statusString, String urlString) {
        return this.apply(statusString, urlString, false);
    }

    public GatewayFilter apply(String statusString, String urlString, boolean includeRequestParams) {
        HttpStatusHolder httpStatus = HttpStatusHolder.parse(statusString);
        Assert.isTrue((boolean)httpStatus.is3xxRedirection(), (String)("status must be a 3xx code, but was " + statusString));
        URI url = URI.create(urlString);
        return this.apply(httpStatus, url, includeRequestParams);
    }

    public GatewayFilter apply(HttpStatus httpStatus, URI uri) {
        return this.apply(new HttpStatusHolder(httpStatus, null), uri, false);
    }

    public GatewayFilter apply(HttpStatus httpStatus, URI uri, boolean includeRequestParams) {
        return this.apply(new HttpStatusHolder(httpStatus, null), uri, includeRequestParams);
    }

    public GatewayFilter apply(HttpStatusHolder httpStatus, URI uri) {
        return this.apply(httpStatus, uri, false);
    }

    public GatewayFilter apply(final HttpStatusHolder httpStatus, final URI uri, final boolean includeRequestParams) {
        return new GatewayFilter(){
            final /* synthetic */ RedirectToGatewayFilterFactory this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
                if (!exchange.getResponse().isCommitted()) {
                    ServerWebExchangeUtils.setResponseStatus(exchange, httpStatus);
                    String location = includeRequestParams ? UriComponentsBuilder.fromUri((URI)uri).queryParams(exchange.getRequest().getQueryParams()).build().toUri().toString() : uri.toString();
                    ServerHttpResponse response = exchange.getResponse();
                    response.getHeaders().set("Location", location);
                    return response.setComplete();
                }
                return Mono.empty();
            }

            public String toString() {
                String status = httpStatus.getHttpStatus() != null ? String.valueOf(httpStatus.getHttpStatus().value()) : httpStatus.getStatus().toString();
                return GatewayToStringStyler.filterToStringCreator(this.this$0).append(status, (Object)uri).append(RedirectToGatewayFilterFactory.INCLUDE_REQUEST_PARAMS_KEY, includeRequestParams).toString();
            }
        };
    }

    public static class Config {
        String status;
        String url;
        boolean includeRequestParams;

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public boolean isIncludeRequestParams() {
            return this.includeRequestParams;
        }

        public void setIncludeRequestParams(boolean includeRequestParams) {
            this.includeRequestParams = includeRequestParams;
        }
    }
}

