/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import java.util.Arrays;
import java.util.List;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.cloud.gateway.support.GatewayToStringStyler;
import org.springframework.core.style.ToStringCreator;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class MapRequestHeaderGatewayFilterFactory
extends AbstractGatewayFilterFactory<Config> {
    public static final String FROM_HEADER_KEY = "fromHeader";
    public static final String TO_HEADER_KEY = "toHeader";

    public MapRequestHeaderGatewayFilterFactory() {
        super(Config.class);
    }

    @Override
    public List<String> shortcutFieldOrder() {
        return Arrays.asList(FROM_HEADER_KEY, TO_HEADER_KEY);
    }

    @Override
    public GatewayFilter apply(final Config config) {
        return new GatewayFilter(){
            final /* synthetic */ MapRequestHeaderGatewayFilterFactory this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
                if (!exchange.getRequest().getHeaders().containsHeader(config.getFromHeader())) {
                    return chain.filter(exchange);
                }
                List headerValues = exchange.getRequest().getHeaders().get(config.getFromHeader());
                ServerHttpRequest request = exchange.getRequest().mutate().headers(i -> i.addAll(config.getToHeader(), headerValues)).build();
                return chain.filter(exchange.mutate().request(request).build());
            }

            public String toString() {
                return GatewayToStringStyler.filterToStringCreator(this.this$0).append(MapRequestHeaderGatewayFilterFactory.FROM_HEADER_KEY, (Object)config.getFromHeader()).append(MapRequestHeaderGatewayFilterFactory.TO_HEADER_KEY, (Object)config.getToHeader()).toString();
            }
        };
    }

    public static class Config {
        private String fromHeader;
        private String toHeader;

        public String getFromHeader() {
            return this.fromHeader;
        }

        public Config setFromHeader(String fromHeader) {
            this.fromHeader = fromHeader;
            return this;
        }

        public String getToHeader() {
            return this.toHeader;
        }

        public Config setToHeader(String toHeader) {
            this.toHeader = toHeader;
            return this;
        }

        public String toString() {
            return new ToStringCreator((Object)this).append(MapRequestHeaderGatewayFilterFactory.FROM_HEADER_KEY, (Object)this.fromHeader).append(MapRequestHeaderGatewayFilterFactory.TO_HEADER_KEY, (Object)this.toHeader).toString();
        }
    }
}

