/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.cloud.function.context.FunctionCatalog;
import org.springframework.cloud.function.context.catalog.SimpleFunctionRegistry;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.cloud.gateway.filter.factory.rewrite.CachedBodyOutputMessage;
import org.springframework.cloud.gateway.filter.factory.rewrite.MessageBodyEncoder;
import org.springframework.cloud.gateway.support.BodyInserterContext;
import org.springframework.cloud.gateway.support.MessageHeaderUtils;
import org.springframework.cloud.gateway.support.NotFoundException;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.core.Ordered;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ReactiveHttpOutputMessage;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MimeType;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class FunctionRoutingFilter
implements GlobalFilter,
Ordered {
    private static Log logger = LogFactory.getLog(FunctionRoutingFilter.class);
    private final FunctionCatalog functionCatalog;
    private final List<HttpMessageReader<?>> messageReaders;
    private final Map<String, MessageBodyEncoder> messageBodyEncoders;

    public FunctionRoutingFilter(FunctionCatalog functionCatalog, List<HttpMessageReader<?>> messageReaders, Set<MessageBodyEncoder> messageBodyEncoders) {
        this.functionCatalog = functionCatalog;
        this.messageReaders = messageReaders;
        this.messageBodyEncoders = messageBodyEncoders.stream().collect(Collectors.toMap(MessageBodyEncoder::encodingType, Function.identity()));
    }

    public int getOrder() {
        return 10010;
    }

    @Override
    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        URI requestUrl = (URI)exchange.getRequiredAttribute(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR);
        String scheme = requestUrl.getScheme();
        if (ServerWebExchangeUtils.isAlreadyRouted(exchange) || !"fn".equals(scheme)) {
            return chain.filter(exchange);
        }
        ServerWebExchangeUtils.setAlreadyRouted(exchange);
        SimpleFunctionRegistry.FunctionInvocationWrapper function = (SimpleFunctionRegistry.FunctionInvocationWrapper)this.functionCatalog.lookup(requestUrl.getHost(), (String[])exchange.getRequest().getHeaders().getAccept().stream().map(MimeType::toString).toArray(String[]::new));
        if (function != null) {
            return this.processRequest(exchange, function, this.messageReaders, this.messageBodyEncoders).then(chain.filter(exchange));
        }
        return Mono.error((Throwable)((Object)new NotFoundException("No route for uri " + String.valueOf(requestUrl))));
    }

    protected Mono<Void> processRequest(ServerWebExchange exchange, SimpleFunctionRegistry.FunctionInvocationWrapper function, List<HttpMessageReader<?>> messageReaders, Map<String, MessageBodyEncoder> messageBodyEncoders) {
        ServerRequest serverRequest = ServerRequest.create((ServerWebExchange)exchange, messageReaders);
        return serverRequest.bodyToMono(function.getRawInputType()).flatMap(requestBody -> {
            Mono result;
            ServerHttpRequest request = exchange.getRequest();
            HttpHeaders headers = request.getHeaders();
            Message inputMessage = null;
            MessageBuilder builder = MessageBuilder.withPayload((Object)requestBody);
            if (!CollectionUtils.isEmpty((Map)request.getQueryParams())) {
                builder = builder.setHeader("http_request_param", (Object)request.getQueryParams().toSingleValueMap());
            }
            inputMessage = builder.copyHeaders(headers.toSingleValueMap()).build();
            if (function.isRoutingFunction()) {
                function.setSkipOutputConversion(true);
            }
            List<String> ignoredHeaders = Collections.emptyList();
            HttpHeaders newResponseHeaders = new HttpHeaders();
            Object functionResult = function.apply((Object)inputMessage);
            if (functionResult instanceof Message) {
                Message message = (Message)functionResult;
                newResponseHeaders.addAll(MessageHeaderUtils.fromMessage(message.getHeaders(), ignoredHeaders));
                functionResult = message.getPayload();
            }
            if (functionResult instanceof Publisher) {
                Publisher publisher = (Publisher)functionResult;
                result = publisher;
            } else {
                result = Mono.just((Object)functionResult);
            }
            Class<byte[]> outClass = byte[].class;
            BodyInserter bodyInserter = BodyInserters.fromPublisher((Publisher)result, outClass);
            CachedBodyOutputMessage outputMessage = new CachedBodyOutputMessage(exchange, exchange.getResponse().getHeaders());
            return bodyInserter.insert((ReactiveHttpOutputMessage)outputMessage, (BodyInserter.Context)new BodyInserterContext()).then(Mono.defer(() -> {
                ServerHttpResponse response = exchange.getResponse();
                Mono messageBody = this.writeBody(response, outputMessage, outClass);
                HttpHeaders responseHeaders = response.getHeaders();
                if (!responseHeaders.containsHeader("Transfer-Encoding") || responseHeaders.containsHeader("Content-Length")) {
                    messageBody = messageBody.doOnNext(data -> headers.setContentLength((long)data.readableByteCount()));
                }
                responseHeaders.addAll(newResponseHeaders);
                return response.writeWith((Publisher)messageBody);
            }));
        });
    }

    private Mono<DataBuffer> writeBody(ServerHttpResponse httpResponse, CachedBodyOutputMessage message, Class<?> outClass) {
        Mono response = DataBufferUtils.join(message.getBody());
        if (byte[].class.isAssignableFrom(outClass)) {
            return response;
        }
        List encodingHeaders = httpResponse.getHeaders().getOrEmpty("Content-Encoding");
        for (String encoding : encodingHeaders) {
            MessageBodyEncoder encoder = this.messageBodyEncoders.get(encoding);
            if (encoder == null) continue;
            DataBufferFactory dataBufferFactory = httpResponse.bufferFactory();
            response = response.publishOn(Schedulers.parallel()).map(buffer -> {
                byte[] encodedResponse = encoder.encode((DataBuffer)buffer);
                DataBufferUtils.release((DataBuffer)buffer);
                return encodedResponse;
            }).map(arg_0 -> ((DataBufferFactory)dataBufferFactory).wrap(arg_0));
            break;
        }
        return response;
    }
}

