/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.support;

import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotEmpty;
import org.springframework.core.style.ToStringCreator;
import org.springframework.validation.annotation.Validated;

@Validated
public class WeightConfig {
    public static final String CONFIG_PREFIX = "weight";
    @NotEmpty
    private String group;
    private String routeId;
    @Min(value=0L)
    private @Min(value=0L) int weight;

    private WeightConfig() {
    }

    public WeightConfig(String group, String routeId, int weight) {
        this.routeId = routeId;
        this.group = group;
        this.weight = weight;
    }

    public WeightConfig(String routeId) {
        this.routeId = routeId;
    }

    public String getGroup() {
        return this.group;
    }

    public WeightConfig setGroup(String group) {
        this.group = group;
        return this;
    }

    public String getRouteId() {
        return this.routeId;
    }

    public WeightConfig setRouteId(String routeId) {
        this.routeId = routeId;
        return this;
    }

    public int getWeight() {
        return this.weight;
    }

    public WeightConfig setWeight(int weight) {
        this.weight = weight;
        return this;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("group", (Object)this.group).append("routeId", (Object)this.routeId).append(CONFIG_PREFIX, this.weight).toString();
    }
}

