/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory.cache.keygenerator;

import java.io.ByteArrayOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.springframework.cloud.gateway.filter.factory.cache.keygenerator.CookiesKeyValueGenerator;
import org.springframework.cloud.gateway.filter.factory.cache.keygenerator.HeaderKeyValueGenerator;
import org.springframework.cloud.gateway.filter.factory.cache.keygenerator.KeyValueGenerator;
import org.springframework.cloud.gateway.filter.factory.cache.keygenerator.UriKeyValueGenerator;
import org.springframework.http.server.reactive.ServerHttpRequest;

public class CacheKeyGenerator {
    static final String KEY_SEPARATOR = ";";
    private static final byte[] KEY_SEPARATOR_BYTES = ";".getBytes();
    private final ThreadLocal<MessageDigest> messageDigest = ThreadLocal.withInitial(() -> {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Error creating CacheKeyGenerator", e);
        }
    });
    static final List<KeyValueGenerator> DEFAULT_KEY_VALUE_GENERATORS = List.of(new UriKeyValueGenerator(), new HeaderKeyValueGenerator("Authorization", ";"), new CookiesKeyValueGenerator(";"));

    public String generateMetadataKey(ServerHttpRequest request, String ... varyHeaders) {
        return "META_" + this.generateKey(request, varyHeaders);
    }

    public String generateKey(ServerHttpRequest request, String ... varyHeaders) {
        return this.generateKey(request, varyHeaders != null ? Arrays.asList(varyHeaders) : Collections.emptyList());
    }

    public String generateKey(ServerHttpRequest request, List<String> varyHeaders) {
        byte[] rawKey = this.generateRawKey(request, varyHeaders);
        byte[] digest = this.messageDigest.get().digest(rawKey);
        return Base64.getEncoder().encodeToString(digest);
    }

    private Stream<KeyValueGenerator> getKeyValueGenerators(List<String> varyHeaders) {
        return Stream.concat(DEFAULT_KEY_VALUE_GENERATORS.stream(), varyHeaders.stream().sorted().map(header -> new HeaderKeyValueGenerator((String)header, ",")));
    }

    private byte[] generateRawKey(ServerHttpRequest request, List<String> varyHeaders) {
        Stream<KeyValueGenerator> keyValueGenerators = this.getKeyValueGenerators(varyHeaders);
        ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
        keyValueGenerators.map(generator -> generator.apply(request)).map(String::getBytes).forEach(bytes -> {
            byteOutputStream.writeBytes((byte[])bytes);
            byteOutputStream.writeBytes(KEY_SEPARATOR_BYTES);
        });
        return byteOutputStream.toByteArray();
    }
}

