/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Arrays;
import java.util.List;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.rewrite.ModifyResponseBodyGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.rewrite.RewriteFunction;
import org.springframework.cloud.gateway.support.ShortcutConfigurable;
import org.springframework.core.style.ToStringCreator;
import org.springframework.http.MediaType;
import reactor.core.publisher.Mono;

public class RemoveJsonAttributesResponseBodyGatewayFilterFactory
extends AbstractGatewayFilterFactory<FieldListConfiguration> {
    private final ModifyResponseBodyGatewayFilterFactory modifyResponseBodyGatewayFilterFactory;
    private ObjectMapper mapper = new ObjectMapper();

    public RemoveJsonAttributesResponseBodyGatewayFilterFactory(ModifyResponseBodyGatewayFilterFactory modifyResponseBodyGatewayFilterFactory) {
        this.modifyResponseBodyGatewayFilterFactory = modifyResponseBodyGatewayFilterFactory;
    }

    @Override
    public ShortcutConfigurable.ShortcutType shortcutType() {
        return ShortcutConfigurable.ShortcutType.GATHER_LIST_TAIL_FLAG;
    }

    @Override
    public List<String> shortcutFieldOrder() {
        return Arrays.asList("fieldList", "deleteRecursively");
    }

    @Override
    public FieldListConfiguration newConfig() {
        return new FieldListConfiguration();
    }

    @Override
    public Class<FieldListConfiguration> getConfigClass() {
        return FieldListConfiguration.class;
    }

    @Override
    public GatewayFilter apply(FieldListConfiguration config) {
        ModifyResponseBodyGatewayFilterFactory.Config modifyResponseBodyConfig = new ModifyResponseBodyGatewayFilterFactory.Config();
        modifyResponseBodyConfig.setInClass(String.class);
        modifyResponseBodyConfig.setOutClass(String.class);
        RewriteFunction rewriteFunction = (exchange, body) -> {
            if (MediaType.APPLICATION_JSON.isCompatibleWith(exchange.getResponse().getHeaders().getContentType())) {
                try {
                    JsonNode jsonNode = (JsonNode)this.mapper.readValue(body, JsonNode.class);
                    this.removeJsonAttributes(jsonNode, config.getFieldList(), config.isDeleteRecursively());
                    body = this.mapper.writeValueAsString((Object)jsonNode);
                }
                catch (JsonProcessingException e) {
                    return Mono.error((Throwable)new IllegalStateException("Failed to process JSON of response body.", e));
                }
            }
            return Mono.just((Object)body);
        };
        modifyResponseBodyConfig.setRewriteFunction(rewriteFunction);
        return this.modifyResponseBodyGatewayFilterFactory.apply(modifyResponseBodyConfig);
    }

    private void removeJsonAttributes(JsonNode jsonNode, List<String> fieldNames, boolean deleteRecursively) {
        if (jsonNode instanceof ObjectNode) {
            ObjectNode objectNode = (ObjectNode)jsonNode;
            objectNode.remove(fieldNames);
        }
        if (deleteRecursively) {
            jsonNode.forEach(childNode -> this.removeJsonAttributes((JsonNode)childNode, fieldNames, true));
        }
    }

    public static class FieldListConfiguration {
        private List<String> fieldList;
        private boolean deleteRecursively;

        public boolean isDeleteRecursively() {
            return this.deleteRecursively;
        }

        public FieldListConfiguration setDeleteRecursively(boolean deleteRecursively) {
            this.deleteRecursively = deleteRecursively;
            return this;
        }

        List<String> getFieldList() {
            return this.fieldList;
        }

        public FieldListConfiguration setFieldList(List<String> fieldList) {
            this.fieldList = fieldList;
            return this;
        }

        public String toString() {
            return new ToStringCreator((Object)this).append("fieldList", this.fieldList).append("deleteRecursively", this.deleteRecursively).toString();
        }
    }
}

