/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.server.mvc.handler;

import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.springframework.cloud.gateway.server.mvc.common.MvcUtils;
import org.springframework.cloud.gateway.server.mvc.handler.GatewayDelegatingRouterFunction;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpHeaders;
import org.springframework.web.servlet.function.HandlerFilterFunction;
import org.springframework.web.servlet.function.HandlerFunction;
import org.springframework.web.servlet.function.RequestPredicate;
import org.springframework.web.servlet.function.RouterFunction;
import org.springframework.web.servlet.function.RouterFunctions;
import org.springframework.web.servlet.function.ServerRequest;
import org.springframework.web.servlet.function.ServerResponse;

public class GatewayRouterFunctionsBuilder
implements RouterFunctions.Builder {
    private final RouterFunctions.Builder builder;
    private final String routeId;

    public GatewayRouterFunctionsBuilder(RouterFunctions.Builder builder, String routeId) {
        this.builder = builder;
        this.routeId = routeId;
    }

    public RouterFunction<ServerResponse> build() {
        RouterFunction routerFunction = this.builder.build();
        RouterFunction withAttributes = routerFunction.withAttribute(MvcUtils.GATEWAY_ROUTE_ID_ATTR, (Object)this.routeId);
        return new GatewayDelegatingRouterFunction<ServerResponse>(withAttributes, this.routeId);
    }

    public RouterFunctions.Builder GET(HandlerFunction<ServerResponse> handlerFunction) {
        this.builder.GET(handlerFunction);
        return this;
    }

    public RouterFunctions.Builder GET(String pattern, HandlerFunction<ServerResponse> handlerFunction) {
        this.builder.GET(pattern, handlerFunction);
        return this;
    }

    public RouterFunctions.Builder GET(RequestPredicate predicate, HandlerFunction<ServerResponse> handlerFunction) {
        this.builder.GET(predicate, handlerFunction);
        return this;
    }

    public RouterFunctions.Builder GET(String pattern, RequestPredicate predicate, HandlerFunction<ServerResponse> handlerFunction) {
        this.builder.GET(pattern, predicate, handlerFunction);
        return this;
    }

    public RouterFunctions.Builder HEAD(HandlerFunction<ServerResponse> handlerFunction) {
        this.builder.HEAD(handlerFunction);
        return this;
    }

    public RouterFunctions.Builder HEAD(String pattern, HandlerFunction<ServerResponse> handlerFunction) {
        this.builder.HEAD(pattern, handlerFunction);
        return this;
    }

    public RouterFunctions.Builder HEAD(RequestPredicate predicate, HandlerFunction<ServerResponse> handlerFunction) {
        this.builder.HEAD(predicate, handlerFunction);
        return this;
    }

    public RouterFunctions.Builder HEAD(String pattern, RequestPredicate predicate, HandlerFunction<ServerResponse> handlerFunction) {
        this.builder.HEAD(pattern, predicate, handlerFunction);
        return this;
    }

    public RouterFunctions.Builder POST(HandlerFunction<ServerResponse> handlerFunction) {
        this.builder.POST(handlerFunction);
        return this;
    }

    public RouterFunctions.Builder POST(String pattern, HandlerFunction<ServerResponse> handlerFunction) {
        this.builder.POST(pattern, handlerFunction);
        return this;
    }

    public RouterFunctions.Builder POST(RequestPredicate predicate, HandlerFunction<ServerResponse> handlerFunction) {
        this.builder.POST(predicate, handlerFunction);
        return this;
    }

    public RouterFunctions.Builder POST(String pattern, RequestPredicate predicate, HandlerFunction<ServerResponse> handlerFunction) {
        this.builder.POST(pattern, predicate, handlerFunction);
        return this;
    }

    public RouterFunctions.Builder PUT(HandlerFunction<ServerResponse> handlerFunction) {
        this.builder.PUT(handlerFunction);
        return this;
    }

    public RouterFunctions.Builder PUT(String pattern, HandlerFunction<ServerResponse> handlerFunction) {
        this.builder.PUT(pattern, handlerFunction);
        return this;
    }

    public RouterFunctions.Builder PUT(RequestPredicate predicate, HandlerFunction<ServerResponse> handlerFunction) {
        this.builder.PUT(predicate, handlerFunction);
        return this;
    }

    public RouterFunctions.Builder PUT(String pattern, RequestPredicate predicate, HandlerFunction<ServerResponse> handlerFunction) {
        this.builder.PUT(pattern, predicate, handlerFunction);
        return this;
    }

    public RouterFunctions.Builder PATCH(HandlerFunction<ServerResponse> handlerFunction) {
        this.builder.PATCH(handlerFunction);
        return this;
    }

    public RouterFunctions.Builder PATCH(String pattern, HandlerFunction<ServerResponse> handlerFunction) {
        this.builder.PATCH(pattern, handlerFunction);
        return this;
    }

    public RouterFunctions.Builder PATCH(RequestPredicate predicate, HandlerFunction<ServerResponse> handlerFunction) {
        this.builder.PATCH(predicate, handlerFunction);
        return this;
    }

    public RouterFunctions.Builder PATCH(String pattern, RequestPredicate predicate, HandlerFunction<ServerResponse> handlerFunction) {
        this.builder.PATCH(pattern, predicate, handlerFunction);
        return this;
    }

    public RouterFunctions.Builder DELETE(HandlerFunction<ServerResponse> handlerFunction) {
        this.builder.DELETE(handlerFunction);
        return this;
    }

    public RouterFunctions.Builder DELETE(String pattern, HandlerFunction<ServerResponse> handlerFunction) {
        this.builder.DELETE(pattern, handlerFunction);
        return this;
    }

    public RouterFunctions.Builder DELETE(RequestPredicate predicate, HandlerFunction<ServerResponse> handlerFunction) {
        this.builder.DELETE(predicate, handlerFunction);
        return this;
    }

    public RouterFunctions.Builder DELETE(String pattern, RequestPredicate predicate, HandlerFunction<ServerResponse> handlerFunction) {
        this.builder.DELETE(pattern, predicate, handlerFunction);
        return this;
    }

    public RouterFunctions.Builder OPTIONS(HandlerFunction<ServerResponse> handlerFunction) {
        this.builder.OPTIONS(handlerFunction);
        return this;
    }

    public RouterFunctions.Builder OPTIONS(String pattern, HandlerFunction<ServerResponse> handlerFunction) {
        this.builder.OPTIONS(pattern, handlerFunction);
        return this;
    }

    public RouterFunctions.Builder OPTIONS(RequestPredicate predicate, HandlerFunction<ServerResponse> handlerFunction) {
        this.builder.OPTIONS(predicate, handlerFunction);
        return this;
    }

    public RouterFunctions.Builder OPTIONS(String pattern, RequestPredicate predicate, HandlerFunction<ServerResponse> handlerFunction) {
        this.builder.OPTIONS(pattern, predicate, handlerFunction);
        return this;
    }

    public RouterFunctions.Builder route(RequestPredicate predicate, HandlerFunction<ServerResponse> handlerFunction) {
        this.builder.route(predicate, handlerFunction);
        return this;
    }

    public RouterFunctions.Builder add(RouterFunction<ServerResponse> routerFunction) {
        this.builder.add(routerFunction);
        return this;
    }

    public RouterFunctions.Builder resource(RequestPredicate predicate, Resource resource) {
        return this.builder.resource(predicate, resource);
    }

    public RouterFunctions.Builder resource(RequestPredicate predicate, Resource resource, BiConsumer<Resource, HttpHeaders> headersConsumer) {
        return this.builder.resource(predicate, resource, headersConsumer);
    }

    public RouterFunctions.Builder resources(String pattern, Resource location) {
        this.builder.resources(pattern, location);
        return this;
    }

    public RouterFunctions.Builder resources(Function<ServerRequest, Optional<Resource>> lookupFunction) {
        this.builder.resources(lookupFunction);
        return this;
    }

    public RouterFunctions.Builder resources(String pattern, Resource location, BiConsumer<Resource, HttpHeaders> headersConsumer) {
        this.builder.resources(pattern, location, headersConsumer);
        return this;
    }

    public RouterFunctions.Builder resources(Function<ServerRequest, Optional<Resource>> lookupFunction, BiConsumer<Resource, HttpHeaders> headersConsumer) {
        this.builder.resources(lookupFunction, headersConsumer);
        return this;
    }

    public RouterFunctions.Builder nest(RequestPredicate predicate, Supplier<RouterFunction<ServerResponse>> routerFunctionSupplier) {
        this.builder.nest(predicate, routerFunctionSupplier);
        return this;
    }

    public RouterFunctions.Builder nest(RequestPredicate predicate, Consumer<RouterFunctions.Builder> builderConsumer) {
        this.builder.nest(predicate, builderConsumer);
        return this;
    }

    public RouterFunctions.Builder path(String pattern, Supplier<RouterFunction<ServerResponse>> routerFunctionSupplier) {
        this.builder.path(pattern, routerFunctionSupplier);
        return this;
    }

    public RouterFunctions.Builder path(String pattern, Consumer<RouterFunctions.Builder> builderConsumer) {
        this.builder.path(pattern, builderConsumer);
        return this;
    }

    public RouterFunctions.Builder filter(HandlerFilterFunction<ServerResponse, ServerResponse> filterFunction) {
        this.builder.filter(filterFunction);
        return this;
    }

    public RouterFunctions.Builder before(Function<ServerRequest, ServerRequest> requestProcessor) {
        this.builder.before(requestProcessor);
        return this;
    }

    public RouterFunctions.Builder after(BiFunction<ServerRequest, ServerResponse, ServerResponse> responseProcessor) {
        this.builder.after(responseProcessor);
        return this;
    }

    public RouterFunctions.Builder onError(Predicate<Throwable> predicate, BiFunction<Throwable, ServerRequest, ServerResponse> responseProvider) {
        this.builder.onError(predicate, responseProvider);
        return this;
    }

    public RouterFunctions.Builder onError(Class<? extends Throwable> exceptionType, BiFunction<Throwable, ServerRequest, ServerResponse> responseProvider) {
        this.builder.onError(exceptionType, responseProvider);
        return this;
    }

    public RouterFunctions.Builder withAttribute(String name, Object value) {
        this.builder.withAttribute(name, value);
        return this;
    }

    public RouterFunctions.Builder withAttributes(Consumer<Map<String, Object>> attributesConsumer) {
        this.builder.withAttributes(attributesConsumer);
        return this;
    }
}

