/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.server.mvc.handler;

import java.lang.reflect.Method;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.springframework.cloud.gateway.server.mvc.common.MvcUtils;
import org.springframework.cloud.gateway.server.mvc.config.RouteProperties;
import org.springframework.cloud.gateway.server.mvc.handler.HandlerDiscoverer;
import org.springframework.cloud.gateway.server.mvc.handler.HandlerFunctions;
import org.springframework.cloud.gateway.server.mvc.handler.HandlerSupplier;
import org.springframework.web.servlet.function.HandlerFilterFunction;
import org.springframework.web.servlet.function.HandlerFunction;
import org.springframework.web.servlet.function.ServerResponse;

class DefaultHandlerSupplier
implements HandlerSupplier {
    DefaultHandlerSupplier() {
    }

    @Override
    public Collection<Method> get() {
        return Arrays.asList(this.getClass().getMethods());
    }

    public static HandlerDiscoverer.Result forward(RouteProperties routeProperties) {
        return DefaultHandlerSupplier.forward(routeProperties.getId(), routeProperties.getUri());
    }

    public static HandlerDiscoverer.Result forward(String id, URI uri) {
        return new HandlerDiscoverer.Result(HandlerFunctions.forward(uri.getPath()), Collections.emptyList());
    }

    public static HandlerDiscoverer.Result http(RouteProperties routeProperties) {
        return DefaultHandlerSupplier.http(routeProperties.getId(), routeProperties.getUri());
    }

    public static HandlerDiscoverer.Result http(String id, URI uri) {
        HandlerFunction<ServerResponse> http = HandlerFunctions.http();
        return DefaultHandlerSupplier.getResult(id, uri, http);
    }

    public static HandlerDiscoverer.Result https(RouteProperties routeProperties) {
        return DefaultHandlerSupplier.https(routeProperties.getId(), routeProperties.getUri());
    }

    public static HandlerDiscoverer.Result https(String id, URI uri) {
        return DefaultHandlerSupplier.getResult(id, uri, HandlerFunctions.https());
    }

    public static HandlerDiscoverer.Result no(RouteProperties routeProperties) {
        return DefaultHandlerSupplier.no(routeProperties.getId(), routeProperties.getUri());
    }

    public static HandlerDiscoverer.Result no(String id, URI uri) {
        return DefaultHandlerSupplier.getResult(id, uri, HandlerFunctions.no());
    }

    private static HandlerDiscoverer.Result getResult(String id, URI uri, HandlerFunction<ServerResponse> handlerFunction) {
        HandlerFilterFunction<ServerResponse, ServerResponse> setId = DefaultHandlerSupplier.setIdFilter(id);
        HandlerFilterFunction<ServerResponse, ServerResponse> setRequest = DefaultHandlerSupplier.setRequestUrlFilter(uri);
        return new HandlerDiscoverer.Result(handlerFunction, Arrays.asList(setId, setRequest), Collections.emptyList());
    }

    private static HandlerFilterFunction<ServerResponse, ServerResponse> setIdFilter(String id) {
        return (request, next) -> {
            MvcUtils.setRouteId(request, id);
            return next.handle(request);
        };
    }

    private static HandlerFilterFunction<ServerResponse, ServerResponse> setRequestUrlFilter(URI uri) {
        return (request, next) -> {
            MvcUtils.setRequestUrl(request, uri);
            return next.handle(request);
        };
    }
}

