/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.webflux.config;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Set;
import org.springframework.cloud.gateway.webflux.ProxyExchange;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpHeaders;
import org.springframework.web.reactive.BindingContext;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.result.method.HandlerMethodArgumentResolver;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class ProxyExchangeArgumentResolver
implements HandlerMethodArgumentResolver {
    private WebClient rest;
    private HttpHeaders headers;
    private Set<String> autoForwardedHeaders;
    private Set<String> excluded;

    public ProxyExchangeArgumentResolver(WebClient builder) {
        this.rest = builder;
    }

    public void setHeaders(HttpHeaders headers) {
        this.headers = headers;
    }

    public void setAutoForwardedHeaders(Set<String> autoForwardedHeaders) {
        this.autoForwardedHeaders = autoForwardedHeaders;
    }

    public void setExcluded(Set<String> excluded) {
        this.excluded = excluded;
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return ProxyExchange.class.isAssignableFrom(parameter.getParameterType());
    }

    private Type type(MethodParameter parameter) {
        Object type = parameter.getGenericParameterType();
        if (type instanceof ParameterizedType) {
            ParameterizedType param = (ParameterizedType)type;
            type = param.getActualTypeArguments()[0];
        }
        if (type instanceof TypeVariable || type instanceof WildcardType) {
            type = Object.class;
        }
        return type;
    }

    public Mono<Object> resolveArgument(MethodParameter parameter, BindingContext bindingContext, ServerWebExchange exchange) {
        ProxyExchange proxy = new ProxyExchange(this.rest, exchange, bindingContext, this.type(parameter));
        proxy.headers(this.headers);
        if (this.autoForwardedHeaders.size() > 0) {
            proxy.headers(this.extractAutoForwardedHeaders(exchange));
        }
        if (this.excluded != null) {
            proxy.excluded(this.excluded.toArray(new String[0]));
        }
        return Mono.just(proxy);
    }

    private HttpHeaders extractAutoForwardedHeaders(ServerWebExchange exchange) {
        HttpHeaders headers = new HttpHeaders();
        exchange.getRequest().getHeaders().forEach((header, values) -> {
            if (this.autoForwardedHeaders.contains(header)) {
                headers.addAll(header, values);
            }
        });
        return headers;
    }
}

