/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.mvc.config;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.cloud.gateway.mvc.config.ProxyExchangeArgumentResolver;
import org.springframework.cloud.gateway.mvc.config.ProxyProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.web.client.DefaultResponseErrorHandler;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration(proxyBeanMethods=false)
@ConditionalOnWebApplication
@ConditionalOnClass(value={HandlerMethodReturnValueHandler.class})
@EnableConfigurationProperties(value={ProxyProperties.class})
public class ProxyResponseAutoConfiguration
implements WebMvcConfigurer {
    @Autowired
    private ApplicationContext context;

    @Bean
    @ConditionalOnMissingBean
    public ProxyExchangeArgumentResolver proxyExchangeArgumentResolver(Optional<RestTemplateBuilder> optional, ProxyProperties proxy) {
        RestTemplateBuilder builder = optional.orElse(new RestTemplateBuilder(new RestTemplateCustomizer[0]));
        RestTemplate template = builder.build();
        template.setErrorHandler((ResponseErrorHandler)new NoOpResponseErrorHandler());
        template.getMessageConverters().add(new ByteArrayHttpMessageConverter(){

            public boolean supports(Class<?> clazz) {
                return true;
            }
        });
        ProxyExchangeArgumentResolver resolver = new ProxyExchangeArgumentResolver(template);
        resolver.setHeaders(proxy.convertHeaders());
        resolver.setAutoForwardedHeaders(proxy.getAutoForward());
        HashSet<String> excludedHeaderNames = new HashSet<String>();
        if (proxy.getSensitive() != null) {
            excludedHeaderNames.addAll(proxy.getSensitive());
        }
        if (proxy.getSkipped() != null) {
            excludedHeaderNames.addAll(proxy.getSkipped());
        }
        resolver.setExcluded(excludedHeaderNames);
        return resolver;
    }

    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
        argumentResolvers.add((HandlerMethodArgumentResolver)this.context.getBean(ProxyExchangeArgumentResolver.class));
    }

    private static class NoOpResponseErrorHandler
    extends DefaultResponseErrorHandler {
        private NoOpResponseErrorHandler() {
        }

        public void handleError(ClientHttpResponse response) throws IOException {
        }
    }
}

