/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.web.source;

import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnNotWebApplication;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.function.context.FunctionCatalog;
import org.springframework.cloud.function.web.source.DestinationResolver;
import org.springframework.cloud.function.web.source.RequestBuilder;
import org.springframework.cloud.function.web.source.SimpleDestinationResolver;
import org.springframework.cloud.function.web.source.SimpleRequestBuilder;
import org.springframework.cloud.function.web.source.SupplierExporter;
import org.springframework.cloud.function.web.source.SupplierProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.core.env.Environment;
import org.springframework.web.reactive.function.client.WebClient;

@Configuration
@ConditionalOnClass(value={WebClient.class})
@Conditional(value={SourceActiveCondition.class})
@EnableConfigurationProperties(value={SupplierProperties.class})
@ConditionalOnProperty(prefix="spring.cloud.function.web.supplier", name={"enabled"}, matchIfMissing=true)
class SupplierAutoConfiguration {
    SupplierAutoConfiguration() {
    }

    @Bean
    public SupplierExporter sourceForwarder(RequestBuilder requestBuilder, DestinationResolver destinationResolver, FunctionCatalog catalog, WebClient.Builder builder, SupplierProperties props) {
        return new SupplierExporter(requestBuilder, destinationResolver, catalog, builder.build(), props);
    }

    @Bean
    public RequestBuilder simpleRequestBuilder(SupplierProperties props, Environment environment) {
        SimpleRequestBuilder builder = new SimpleRequestBuilder(environment);
        if (props.getTemplateUrl() != null) {
            builder.setTemplateUrl(props.getTemplateUrl());
        }
        builder.setHeaders(props.getHeaders());
        return builder;
    }

    @Bean
    @ConditionalOnMissingBean
    public DestinationResolver simpleDestinationResolver() {
        return new SimpleDestinationResolver();
    }

    static class SourceActiveCondition
    extends AnyNestedCondition {
        public SourceActiveCondition() {
            super(ConfigurationCondition.ConfigurationPhase.PARSE_CONFIGURATION);
        }

        @ConditionalOnProperty(prefix="spring.cloud.function.web.supplier", name={"enabled"})
        static class Enabled {
            Enabled() {
            }
        }

        @ConditionalOnNotWebApplication
        static class OnNotWebapp {
            OnNotWebapp() {
            }
        }
    }
}

