/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.stream.config;

import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="spring.cloud.function.stream")
public class StreamConfigurationProperties {
    private Source source = new Source();
    private Sink sink = new Sink();
    private Processor processor = new Processor();
    private boolean shared;
    public static final String ROUTE_KEY = "stream_routekey";

    public Sink getSink() {
        return this.sink;
    }

    public Source getSource() {
        return this.source;
    }

    public Processor getProcessor() {
        return this.processor;
    }

    public boolean isShared() {
        return this.shared;
    }

    public void setShared(boolean shared) {
        this.shared = shared;
    }

    public String getDefaultRoute() {
        return this.processor.getName() != null ? this.processor.getName() : this.sink.getName();
    }

    public static class Processor {
        private String name;
        private boolean enabled;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }

    public static class Source {
        private String name;
        private boolean enabled;
        private long interval = 0L;

        public long getInterval() {
            return this.interval;
        }

        public void setInterval(long interval) {
            this.interval = interval;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    public static class Sink {
        private String name;
        private boolean enabled;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }
}

