/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.serverless.web;

import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.jar.Manifest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.KotlinDetector;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public final class FunctionClassUtils {
    private static Log logger = LogFactory.getLog(FunctionClassUtils.class);
    private static Class<?> MAIN_CLASS;

    private FunctionClassUtils() {
    }

    public static Class<?> getStartClass() {
        if (MAIN_CLASS == null) {
            ClassLoader classLoader = FunctionClassUtils.class.getClassLoader();
            MAIN_CLASS = FunctionClassUtils.getStartClass(classLoader);
        }
        return MAIN_CLASS;
    }

    static Class<?> getStartClass(ClassLoader classLoader) {
        Class<?> mainClass = null;
        if (System.getenv("MAIN_CLASS") != null) {
            mainClass = ClassUtils.resolveClassName((String)System.getenv("MAIN_CLASS"), (ClassLoader)classLoader);
        } else if (System.getProperty("MAIN_CLASS") != null) {
            mainClass = ClassUtils.resolveClassName((String)System.getProperty("MAIN_CLASS"), (ClassLoader)classLoader);
        } else {
            try {
                Class<?> result = FunctionClassUtils.getStartClass(Collections.list(classLoader.getResources("META-INF/MANIFEST.MF")), classLoader);
                if (result == null) {
                    result = FunctionClassUtils.getStartClass(Collections.list(classLoader.getResources("meta-inf/manifest.mf")), classLoader);
                }
                Assert.notNull(result, (String)"Failed to locate main class");
                mainClass = result;
            }
            catch (Exception ex) {
                throw new IllegalStateException("Failed to discover main class. An attempt was made to discover main class as 'MAIN_CLASS' environment variable, system property as well as entry in META-INF/MANIFEST.MF (in that order).", ex);
            }
        }
        logger.info((Object)("Main class: " + mainClass));
        return mainClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Class<?> getStartClass(List<URL> list, ClassLoader classLoader) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Searching manifests: " + list));
        }
        for (URL url : list) {
            try {
                InputStream inputStream = null;
                Manifest manifest = new Manifest(url.openStream());
                logger.info((Object)("Searching for start class in manifest: " + url));
                if (logger.isDebugEnabled()) {
                    manifest.write(System.out);
                }
                try {
                    Class startClass;
                    String startClassName = manifest.getMainAttributes().getValue("Start-Class");
                    if (!StringUtils.hasText((String)startClassName)) {
                        startClassName = manifest.getMainAttributes().getValue("Main-Class");
                    }
                    if (!StringUtils.hasText((String)startClassName) || !KotlinDetector.isKotlinType((Class)(startClass = ClassUtils.forName((String)startClassName, (ClassLoader)classLoader)))) continue;
                    PathMatchingResourcePatternResolver r = new PathMatchingResourcePatternResolver(classLoader);
                    String packageName = startClass.getPackage().getName();
                    Resource[] resources = r.getResources("classpath:" + packageName.replace(".", "/") + "/*.class");
                    for (int i = 0; i < resources.length; ++i) {
                        Resource resource = resources[i];
                        String className = packageName + "." + resource.getFilename().replace("/", ".").replace(".class", "");
                        startClass = ClassUtils.forName((String)className, (ClassLoader)classLoader);
                    }
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            catch (Exception ex) {
                logger.debug((Object)("Failed to determine Start-Class in manifest file of " + url), (Throwable)ex);
            }
        }
        return null;
    }
}

