/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.integration.dsl;

import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.springframework.cloud.function.integration.dsl.FunctionLookupHelper;
import org.springframework.integration.dsl.IntegrationFlow;
import org.springframework.integration.dsl.IntegrationFlowExtension;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;

public final class FunctionFlowDefinition
extends IntegrationFlowExtension<FunctionFlowDefinition> {
    private final FunctionLookupHelper functionLookupHelper;

    FunctionFlowDefinition(FunctionLookupHelper functionLookupHelper) {
        this.functionLookupHelper = functionLookupHelper;
    }

    MessageChannel getInputChannel() {
        return this.getCurrentMessageChannel();
    }

    void addUpstreamComponents(Map<Object, String> components) {
        this.addComponents(components);
    }

    public FunctionFlowDefinition apply(String functionDefinition) {
        return this.apply(this.functionLookupHelper.lookupFunction(functionDefinition));
    }

    public FunctionFlowDefinition apply(Function<Message<?>, ?> function) {
        return (FunctionFlowDefinition)this.handle(Message.class, (message, headers) -> function.apply((Message<?>)message));
    }

    public IntegrationFlow accept(String consumerDefinition) {
        return this.accept(this.functionLookupHelper.lookupConsumer(consumerDefinition));
    }

    public IntegrationFlow accept(Consumer<Message<?>> consumer) {
        return ((FunctionFlowDefinition)this.handle(consumer::accept)).get();
    }
}

