/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.deployer;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.loader.JarLauncher;
import org.springframework.boot.loader.LaunchedURLClassLoader;
import org.springframework.boot.loader.archive.Archive;
import org.springframework.boot.loader.jar.JarFile;
import org.springframework.cloud.function.context.FunctionRegistration;
import org.springframework.cloud.function.context.FunctionRegistry;
import org.springframework.cloud.function.context.catalog.FunctionTypeUtils;
import org.springframework.cloud.function.deployer.DeployerContextUtils;
import org.springframework.cloud.function.deployer.FunctionDeployerProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.core.type.filter.RegexPatternTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.TypeLocator;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.expression.spel.support.StandardTypeLocator;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StreamUtils;
import org.springframework.util.StringUtils;

class FunctionArchiveDeployer
extends JarLauncher {
    private static Log logger = LogFactory.getLog(FunctionArchiveDeployer.class);
    private final StandardEvaluationContext evalContext = new StandardEvaluationContext();
    private LaunchedURLClassLoader archiveLoader;

    FunctionArchiveDeployer(Archive archive) {
        super(archive);
    }

    void deploy(FunctionRegistry functionRegistry, FunctionDeployerProperties functionProperties, String[] args, ApplicationContext applicationContext) {
        ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
        try {
            String[] functionClassNames;
            ClassLoader cl = this.createClassLoader(this.discoverClassPathAcrhives().iterator());
            Thread.currentThread().setContextClassLoader(cl);
            this.evalContext.setTypeLocator((TypeLocator)new StandardTypeLocator(Thread.currentThread().getContextClassLoader()));
            if (this.isBootApplicationWithMain()) {
                this.launchFunctionArchive(args);
                Map<String, Object> functions = this.discoverBeanFunctions();
                if (logger.isInfoEnabled() && !CollectionUtils.isEmpty(functions)) {
                    logger.info((Object)("Discovered functions in deployed application context: " + functions));
                }
                for (Map.Entry entry : functions.entrySet()) {
                    FunctionRegistration registration = new FunctionRegistration(entry.getValue(), new String[]{(String)entry.getKey()});
                    Type type = this.discoverFunctionType((String)entry.getKey());
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("Registering function '" + (String)entry.getKey() + "' of type '" + type + "' in FunctionRegistry."));
                    }
                    registration.type(type);
                    functionRegistry.register(registration);
                }
            }
            if ((functionClassNames = this.discoverFunctionClassName(functionProperties)) == null) {
                ClassPathBeanDefinitionScanner scanner = new ClassPathBeanDefinitionScanner((BeanDefinitionRegistry)applicationContext, false);
                scanner.addIncludeFilter((TypeFilter)new RegexPatternTypeFilter(Pattern.compile(".*")));
                Set set = scanner.findCandidateComponents("functions");
                ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
                for (BeanDefinition beanDefinition : set) {
                    FunctionRegistration<?> registration;
                    String className = beanDefinition.getBeanClassName();
                    Class<?> functionClass = currentClassLoader.loadClass(className);
                    if (!Function.class.isAssignableFrom(functionClass) && !Supplier.class.isAssignableFrom(functionClass) && !Consumer.class.isAssignableFrom(functionClass) || (registration = this.discovereAndLoadFunctionFromClassName(className)) == null) continue;
                    functionRegistry.register(registration);
                }
            } else {
                for (String functionClassName : functionClassNames) {
                    FunctionRegistration<?> registration;
                    if (!StringUtils.hasText((String)functionClassName) || (registration = this.discovereAndLoadFunctionFromClassName(functionClassName)) == null) continue;
                    functionRegistry.register(registration);
                }
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to deploy archive " + this.getArchive(), e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentLoader);
        }
    }

    void undeploy() {
        this.stopDeployedApplicationContext();
        try {
            this.archiveLoader.close();
            logger.info((Object)"Closed archive class loader");
        }
        catch (IOException e) {
            logger.error((Object)"Failed to closed archive class loader", (Throwable)e);
        }
    }

    protected ClassLoader createClassLoader(Iterator<Archive> archives) throws Exception {
        URLClassLoader cl = (URLClassLoader)super.createClassLoader(archives);
        return this.createClassLoader(cl.getURLs());
    }

    protected ClassLoader createClassLoader(URL[] urls) throws Exception {
        String classAsPath = DeployerContextUtils.class.getName().replace('.', '/') + ".class";
        final byte[] deployerContextUtilsBytes = StreamUtils.copyToByteArray((InputStream)DeployerContextUtils.class.getClassLoader().getResourceAsStream(classAsPath));
        final ClassLoader deployerClassLoader = ((Object)((Object)this)).getClass().getClassLoader();
        this.archiveLoader = new LaunchedURLClassLoader(urls, deployerClassLoader.getParent()){

            public Class<?> loadClass(String name) throws ClassNotFoundException {
                Class clazz = null;
                if (FunctionArchiveDeployer.this.shouldLoadViaDeployerLoader(name)) {
                    clazz = deployerClassLoader.loadClass(name);
                } else if (name.equals(DeployerContextUtils.class.getName())) {
                    try {
                        clazz = super.loadClass(name, false);
                    }
                    catch (Exception e) {
                        clazz = this.defineClass(name, deployerContextUtilsBytes, 0, deployerContextUtilsBytes.length);
                    }
                } else {
                    clazz = super.loadClass(name, false);
                }
                return clazz;
            }
        };
        return this.archiveLoader;
    }

    private boolean shouldLoadViaDeployerLoader(String name) {
        return name.startsWith("org.reactivestreams") || name.startsWith("reactor.") || name.startsWith("io.cloudevents") || name.startsWith("org.springframework.messaging.Message") || name.startsWith("org.springframework.messaging.converter.MessageConverter");
    }

    private String[] discoverFunctionClassName(FunctionDeployerProperties functionProperties) {
        try {
            if (StringUtils.hasText((String)functionProperties.getFunctionClass())) {
                return functionProperties.getFunctionClass().split(";");
            }
            if (StringUtils.hasText((String)this.getArchive().getManifest().getMainAttributes().getValue("Function-Class"))) {
                return new String[]{this.getArchive().getManifest().getMainAttributes().getValue("Function-Class")};
            }
            return null;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to discover function class name", e);
        }
    }

    private boolean isBootApplicationWithMain() {
        try {
            if (this.getArchive().getManifest() == null) {
                return false;
            }
            return StringUtils.hasText((String)this.getArchive().getManifest().getMainAttributes().getValue("Start-Class"));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private List<Archive> discoverClassPathAcrhives() throws Exception {
        Iterator iter = this.getClassPathArchivesIterator();
        ArrayList<Archive> classPathArchives = new ArrayList<Archive>();
        while (iter.hasNext()) {
            classPathArchives.add((Archive)iter.next());
        }
        if (CollectionUtils.isEmpty(classPathArchives)) {
            classPathArchives.add(this.getArchive());
        }
        return classPathArchives;
    }

    private FunctionRegistration<?> discovereAndLoadFunctionFromClassName(String functionClassName) throws Exception {
        FunctionRegistration functionRegistration = null;
        final AtomicReference typeRef = new AtomicReference();
        Class<?> functionClass = Thread.currentThread().getContextClassLoader().loadClass(functionClassName);
        ReflectionUtils.doWithMethods(functionClass, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                typeRef.set(FunctionTypeUtils.discoverFunctionTypeFromFunctionMethod((Method)method));
            }
        }, (ReflectionUtils.MethodFilter)new ReflectionUtils.MethodFilter(){

            public boolean matches(Method method) {
                String name = method.getName();
                return typeRef.get() == null && !method.isBridge() && ("apply".equals(name) || "accept".equals(name) || "get".equals(name));
            }
        });
        if (typeRef.get() != null) {
            Object functionInstance = functionClass.newInstance();
            String functionName = StringUtils.uncapitalize((String)functionClass.getSimpleName());
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Registering function class '" + functionClass + "' of type '" + typeRef.get() + "' under name '" + functionName + "'."));
            }
            functionRegistration = new FunctionRegistration(functionInstance, new String[]{functionName});
            functionRegistration.type((Type)typeRef.get());
        }
        return functionRegistration;
    }

    private void launchFunctionArchive(String[] args) throws Exception {
        JarFile.registerUrlProtocolHandler();
        String mainClassName = this.getMainClass();
        Class<?> mainClass = Thread.currentThread().getContextClassLoader().loadClass(mainClassName);
        Class<?> bootAppClass = Thread.currentThread().getContextClassLoader().loadClass(SpringApplication.class.getName());
        Method runMethod = bootAppClass.getDeclaredMethod("run", Class.class, String[].class);
        Object applicationContext = runMethod.invoke(null, mainClass, args);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Application context for archive '" + this.getArchive().getUrl() + "' is created."));
        }
        this.evalContext.setVariable("context", applicationContext);
        this.setBeanFactory(applicationContext);
    }

    private void setBeanFactory(Object applicationContext) {
        Expression parsed = new SpelExpressionParser().parseExpression("#context.getBeanFactory()");
        Object beanFactory = parsed.getValue((EvaluationContext)this.evalContext);
        this.evalContext.setVariable("bf", beanFactory);
    }

    private Type discoverFunctionType(String name) {
        this.evalContext.setVariable("functionName", (Object)name);
        String expr = "T(" + DeployerContextUtils.class.getName() + ").findType(#bf, #functionName)";
        Expression parsed = new SpelExpressionParser().parseExpression(expr);
        Object type = parsed.getValue((EvaluationContext)this.evalContext);
        return (Type)type;
    }

    private void stopDeployedApplicationContext() {
        if (this.evalContext.lookupVariable("context") != null) {
            Expression parsed = new SpelExpressionParser().parseExpression("#context.stop()");
            parsed.getValue((EvaluationContext)this.evalContext);
        }
    }

    private Map<String, Object> discoverBeanFunctions() {
        HashMap<String, Object> allFunctions = new HashMap<String, Object>();
        if (this.evalContext.lookupVariable("context") != null) {
            Expression parsed = new SpelExpressionParser().parseExpression("#context.getBeansOfType(T(java.util.function.Function))");
            allFunctions.putAll((Map)parsed.getValue((EvaluationContext)this.evalContext));
            parsed = new SpelExpressionParser().parseExpression("#context.getBeansOfType(T(java.util.function.Supplier))");
            allFunctions.putAll((Map)parsed.getValue((EvaluationContext)this.evalContext));
            parsed = new SpelExpressionParser().parseExpression("#context.getBeansOfType(T(java.util.function.Consumer))");
            allFunctions.putAll((Map)parsed.getValue((EvaluationContext)this.evalContext));
        }
        return allFunctions;
    }
}

