/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.context.wrapper;

import java.lang.reflect.Type;
import java.util.function.Consumer;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.springframework.cloud.function.context.wrapper.KotlinFunctionWrapper;
import org.springframework.cloud.function.utils.KotlinUtils;
import org.springframework.core.ResolvableType;

public final class KotlinConsumerPlainWrapper
implements KotlinFunctionWrapper,
Consumer<Object>,
Function1<Object, Unit> {
    private final Object kotlinLambdaTarget;
    private final String name;
    private final ResolvableType type;

    public static Boolean isValid(Type functionType, Type[] types) {
        return KotlinUtils.isValidKotlinConsumer(functionType, types) && !KotlinUtils.isFlowType(types[0]);
    }

    public static KotlinConsumerPlainWrapper asRegistrationFunction(String functionName, Object kotlinLambdaTarget, Type[] propsTypes) {
        ResolvableType functionType = ResolvableType.forClassWithGenerics(Consumer.class, (ResolvableType[])new ResolvableType[]{ResolvableType.forType((Type)propsTypes[0])});
        return new KotlinConsumerPlainWrapper(kotlinLambdaTarget, functionType, functionName);
    }

    public KotlinConsumerPlainWrapper(Object kotlinLambdaTarget, ResolvableType type, String functionName) {
        this.name = functionName;
        this.kotlinLambdaTarget = kotlinLambdaTarget;
        this.type = type;
    }

    @Override
    public ResolvableType getResolvableType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void accept(Object input) {
        this.invoke(input);
    }

    public Unit invoke(Object input) {
        if (this.kotlinLambdaTarget instanceof Function1) {
            ((Function1)this.kotlinLambdaTarget).invoke(input);
            return Unit.INSTANCE;
        }
        if (this.kotlinLambdaTarget instanceof Consumer) {
            ((Consumer)this.kotlinLambdaTarget).accept(input);
            return Unit.INSTANCE;
        }
        throw new IllegalArgumentException("Unsupported target type: " + this.kotlinLambdaTarget.getClass());
    }
}

