/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.context.config;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import org.springframework.cloud.function.cloudevent.CloudEventMessageUtils;
import org.springframework.cloud.function.json.JsonMapper;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.AbstractMessageConverter;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;
import org.springframework.util.StringUtils;

public class JsonMessageConverter
extends AbstractMessageConverter {
    private final JsonMapper jsonMapper;

    public JsonMessageConverter(JsonMapper jsonMapper) {
        this(jsonMapper, new MimeType(MimeTypeUtils.APPLICATION_JSON, StandardCharsets.UTF_8), new MimeType(CloudEventMessageUtils.APPLICATION_CLOUDEVENTS.getType(), CloudEventMessageUtils.APPLICATION_CLOUDEVENTS.getSubtype() + "+json"));
    }

    public JsonMessageConverter(JsonMapper jsonMapper, MimeType ... supportedMimeTypes) {
        super(supportedMimeTypes);
        this.jsonMapper = jsonMapper;
    }

    protected boolean supports(Class<?> clazz) {
        throw new UnsupportedOperationException();
    }

    protected boolean canConvertTo(Object payload, @Nullable MessageHeaders headers) {
        return this.supportsMimeType(headers);
    }

    protected boolean canConvertFrom(Message<?> message, @Nullable Class<?> targetClass) {
        return this.supportsMimeType(message.getHeaders()) && this.canDiscoverConvertToType(message, targetClass);
    }

    private boolean canDiscoverConvertToType(Message<?> message, Class<?> targetClass) {
        if (targetClass == null || targetClass == Object.class) {
            MimeType mimeType = this.getMimeType(message.getHeaders());
            return mimeType != null && StringUtils.hasText((String)mimeType.getParameter("type"));
        }
        return true;
    }

    protected Object convertFromInternal(Message<?> message, Class<?> targetClass, @Nullable Object conversionHint) {
        Object type;
        Class<?> convertToType;
        if (conversionHint instanceof ParameterizedTypeReference) {
            conversionHint = ((ParameterizedTypeReference)conversionHint).getType();
        }
        if ((convertToType = this.getResolvedType(targetClass, conversionHint)) == null || convertToType == Object.class) {
            MimeType mimeType = this.getMimeType(message.getHeaders());
            type = mimeType.getParameter("type");
            if (StringUtils.hasText((String)type)) {
                try {
                    convertToType = Thread.currentThread().getContextClassLoader().loadClass((String)type);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException("Failed to load class `" + (String)type + "` specified by the provided content-type: " + mimeType, e);
                }
            } else {
                return message.getPayload();
            }
        }
        if (targetClass == byte[].class && (type = message.getPayload()) instanceof String) {
            String stringPayload = (String)type;
            return stringPayload.getBytes(StandardCharsets.UTF_8);
        }
        try {
            return this.jsonMapper.fromJson(message.getPayload(), convertToType);
        }
        catch (Exception e) {
            if (message.getPayload() instanceof byte[] && String.class.isAssignableFrom(targetClass)) {
                return new String((byte[])message.getPayload(), StandardCharsets.UTF_8);
            }
            if (this.logger.isDebugEnabled()) {
                Object payload = message.getPayload();
                if (payload instanceof byte[]) {
                    byte[] bytePayload = (byte[])payload;
                    payload = new String(bytePayload, StandardCharsets.UTF_8);
                }
                this.logger.debug((Object)("Failed to convert value: " + payload + " to: " + targetClass), (Throwable)e);
            }
            return null;
        }
    }

    protected Object convertToInternal(Object payload, @Nullable MessageHeaders headers, @Nullable Object conversionHint) {
        if (payload.getClass().getName().equals("org.springframework.kafka.support.KafkaNull")) {
            return payload;
        }
        return this.jsonMapper.toJson(payload);
    }

    private Type getResolvedType(Class<?> targetClass, @Nullable Object conversionHint) {
        if (conversionHint instanceof MethodParameter) {
            MethodParameter param = (MethodParameter)conversionHint;
            if (Message.class.isAssignableFrom((param = param.nestedIfOptional()).getParameterType())) {
                param = param.nested();
            }
            Type genericParameterType = param.getNestedGenericParameterType();
            Class contextClass = param.getContainingClass();
            return GenericTypeResolver.resolveType((Type)genericParameterType, (Class)contextClass);
        }
        if (conversionHint instanceof ParameterizedType) {
            return (Type)conversionHint;
        }
        return targetClass;
    }
}

