/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.utils;

import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.jar.Manifest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public final class FunctionClassUtils {
    private static Log logger = LogFactory.getLog(FunctionClassUtils.class);

    private FunctionClassUtils() {
    }

    public static Class<?> getStartClass() {
        ClassLoader classLoader = FunctionClassUtils.class.getClassLoader();
        return FunctionClassUtils.getStartClass(classLoader);
    }

    private static Class<?> getStartClass(ClassLoader classLoader) {
        Class<?> mainClass = null;
        if (System.getenv("MAIN_CLASS") != null) {
            mainClass = ClassUtils.resolveClassName((String)System.getenv("MAIN_CLASS"), (ClassLoader)classLoader);
        } else if (System.getProperty("MAIN_CLASS") != null) {
            mainClass = ClassUtils.resolveClassName((String)System.getProperty("MAIN_CLASS"), (ClassLoader)classLoader);
        } else {
            try {
                Class<?> result = FunctionClassUtils.getStartClass(Collections.list(classLoader.getResources("META-INF/MANIFEST.MF")));
                if (result == null) {
                    result = FunctionClassUtils.getStartClass(Collections.list(classLoader.getResources("meta-inf/manifest.mf")));
                }
                Assert.notNull(result, (String)"Failed to locate main class");
                mainClass = result;
            }
            catch (Exception ex) {
                throw new IllegalStateException("Failed to discover main class. An attempt was made to discover main class as 'MAIN_CLASS' environment variable, system property as well as entry in META-INF/MANIFEST.MF (in that order).", ex);
            }
        }
        logger.info((Object)("Main class: " + mainClass));
        return mainClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Class<?> getStartClass(List<URL> list) {
        logger.info((Object)("Searching manifests: " + list));
        Iterator<URL> iterator = list.iterator();
        while (iterator.hasNext()) {
            URL url = iterator.next();
            try {
                logger.info((Object)("Searching manifest: " + url));
                InputStream inputStream = null;
                try {
                    Class startClass;
                    Manifest manifest = new Manifest(url.openStream());
                    String startClassName = manifest.getMainAttributes().getValue("Start-Class");
                    if (!StringUtils.hasText((String)startClassName)) {
                        startClassName = manifest.getMainAttributes().getValue("Main-Class");
                    }
                    if (!StringUtils.hasText((String)startClassName) || (startClass = ClassUtils.forName((String)startClassName, (ClassLoader)FunctionClassUtils.class.getClassLoader())).getDeclaredAnnotation(SpringBootApplication.class) == null) continue;
                    logger.info((Object)("Loaded Start Class: " + startClass));
                    Class clazz = startClass;
                    return clazz;
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            catch (Exception ex) {
                logger.debug((Object)("Failed to determine Start-Class in manifest file of " + url), (Throwable)ex);
            }
        }
        return null;
    }
}

