/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.adapter.gcp;

import com.google.cloud.functions.Context;
import com.google.cloud.functions.HttpFunction;
import com.google.cloud.functions.HttpRequest;
import com.google.cloud.functions.HttpResponse;
import com.google.cloud.functions.RawBackgroundFunction;
import java.util.Collections;
import java.util.Iterator;
import org.springframework.boot.loader.JarLauncher;
import org.springframework.boot.loader.archive.Archive;
import org.springframework.boot.loader.jar.JarFile;

public class GcfJarLauncher
extends JarLauncher
implements HttpFunction,
RawBackgroundFunction {
    private final ClassLoader loader;
    private final Object delegate;

    public GcfJarLauncher() throws Exception {
        JarFile.registerUrlProtocolHandler();
        this.loader = this.createClassLoader(this.discoverClassPathAcrhives());
        Class<?> clazz = this.loader.loadClass("org.springframework.cloud.function.adapter.gcp.FunctionInvoker");
        this.delegate = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public void service(HttpRequest httpRequest, HttpResponse httpResponse) throws Exception {
        Thread.currentThread().setContextClassLoader(this.loader);
        ((HttpFunction)this.delegate).service(httpRequest, httpResponse);
    }

    public void accept(String json, Context context) {
        Thread.currentThread().setContextClassLoader(this.loader);
        ((RawBackgroundFunction)this.delegate).accept(json, context);
    }

    private Iterator<Archive> discoverClassPathAcrhives() throws Exception {
        Iterator classPathArchives = this.getClassPathArchivesIterator();
        if (classPathArchives.hasNext()) {
            return classPathArchives;
        }
        return Collections.singleton(this.getArchive()).iterator();
    }
}

