/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.adapter.azure;

import com.microsoft.azure.functions.ExecutionContext;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.jar.Manifest;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.function.context.FunctionCatalog;
import org.springframework.cloud.function.context.FunctionRegistration;
import org.springframework.cloud.function.context.FunctionType;
import org.springframework.cloud.function.context.FunctionalSpringApplication;
import org.springframework.cloud.function.context.catalog.FunctionInspector;
import org.springframework.cloud.function.context.config.FunctionContextUtils;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.util.ClassUtils;

public class AzureSpringFunctionInitializer
implements Closeable {
    private static volatile ConfigurableApplicationContext context;
    private final Class<?> configurationClass;
    private volatile Function<Publisher<?>, Publisher<?>> function;
    private AtomicBoolean initialized = new AtomicBoolean();
    @Autowired(required=false)
    private volatile FunctionCatalog catalog;
    @Autowired(required=false)
    private volatile FunctionInspector inspector;

    public AzureSpringFunctionInitializer(Class<?> configurationClass) {
        this.configurationClass = configurationClass == null ? this.getClass() : configurationClass;
    }

    public AzureSpringFunctionInitializer() {
        this(AzureSpringFunctionInitializer.getStartClass());
    }

    private static Class<?> getStartClass() {
        ClassLoader classLoader = AzureSpringFunctionInitializer.class.getClassLoader();
        if (System.getenv("MAIN_CLASS") != null) {
            return ClassUtils.resolveClassName((String)System.getenv("MAIN_CLASS"), (ClassLoader)classLoader);
        }
        try {
            Class<?> result = AzureSpringFunctionInitializer.getStartClass(Collections.list(classLoader.getResources("META-INF/MANIFEST.MF")));
            if (result == null) {
                result = AzureSpringFunctionInitializer.getStartClass(Collections.list(classLoader.getResources("meta-inf/manifest.mf")));
            }
            return result;
        }
        catch (Exception ex) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Class<?> getStartClass(List<URL> list) {
        Iterator<URL> iterator = list.iterator();
        while (iterator.hasNext()) {
            URL url = iterator.next();
            try (InputStream inputStream = url.openStream();){
                Class aClass;
                SpringBootApplication declaredAnnotation;
                Manifest manifest = new Manifest(inputStream);
                String startClass = manifest.getMainAttributes().getValue("Main-Class");
                if (startClass == null || (declaredAnnotation = (aClass = ClassUtils.forName((String)startClass, (ClassLoader)AzureSpringFunctionInitializer.class.getClassLoader())).getDeclaredAnnotation(SpringBootApplication.class)) == null) continue;
                Class clazz = aClass;
                return clazz;
            }
            catch (Exception exception) {}
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        if (context != null) {
            context.close();
            context = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void initialize(ExecutionContext ctxt) {
        String name;
        ConfigurableApplicationContext context = AzureSpringFunctionInitializer.context;
        if (!this.initialized.compareAndSet(false, true)) {
            return;
        }
        if (ctxt != null) {
            ctxt.getLogger().info("Initializing functions");
        }
        if (context == null) {
            Class<AzureSpringFunctionInitializer> clazz = AzureSpringFunctionInitializer.class;
            // MONITORENTER : org.springframework.cloud.function.adapter.azure.AzureSpringFunctionInitializer.class
            if (context == null) {
                ClassUtils.overrideThreadContextClassLoader((ClassLoader)AzureSpringFunctionInitializer.class.getClassLoader());
                AzureSpringFunctionInitializer.context = context = this.springApplication().run(new String[0]);
            }
            // MONITOREXIT : clazz
        }
        context.getAutowireCapableBeanFactory().autowireBean((Object)this);
        if (ctxt != null) {
            ctxt.getLogger().info("Initialized context: catalog=" + this.catalog);
        }
        if ((name = context.getEnvironment().getProperty("function.name")) == null) {
            name = "function";
        }
        if (this.catalog == null) {
            if (!context.containsBean(name)) return;
            if (ctxt != null) {
                ctxt.getLogger().info("No catalog. Looking for Function bean name=" + name);
            }
            this.function = (Function)this.getAndInstrumentFromContext(context, name);
            return;
        }
        Set functionNames = this.catalog.getNames(Function.class);
        if (functionNames.size() == 1) {
            this.function = (Function)this.catalog.lookup(Function.class, (String)functionNames.iterator().next());
            return;
        }
        this.function = (Function)this.catalog.lookup(Function.class, name);
    }

    private <T> T getAndInstrumentFromContext(ConfigurableApplicationContext applicationContext, String name) {
        FunctionRegistration functionRegistration = new FunctionRegistration(applicationContext.getBean(name), new String[]{name});
        Type type = FunctionContextUtils.findType((String)name, (ConfigurableListableBeanFactory)applicationContext.getBeanFactory());
        FunctionType functionType = new FunctionType(type);
        return (T)functionRegistration.type(functionType).wrap().getTarget();
    }

    private SpringApplication springApplication() {
        Class<?> sourceClass = this.configurationClass;
        FunctionalSpringApplication application = new FunctionalSpringApplication(new Class[]{sourceClass});
        application.setWebApplicationType(WebApplicationType.NONE);
        return application;
    }

    protected boolean isSingleInput(Function<?, ?> function, Object input) {
        if (!(input instanceof Collection)) {
            return true;
        }
        if (this.inspector != null) {
            return Collection.class.isAssignableFrom(this.inspector.getInputType(function));
        }
        return ((Collection)input).size() <= 1;
    }

    protected boolean isSingleOutput(Function<?, ?> function, Object output) {
        if (!(output instanceof Collection)) {
            return true;
        }
        if (this.inspector != null) {
            return Collection.class.isAssignableFrom(this.inspector.getOutputType(function));
        }
        return ((Collection)output).size() <= 1;
    }

    protected Function<Publisher<?>, Publisher<?>> lookup(String name) {
        Function preferred;
        Function function = this.function;
        if (name != null && this.catalog != null && (preferred = (Function)this.catalog.lookup(Function.class, name)) != null) {
            function = preferred;
        }
        if (function != null) {
            return function;
        }
        throw new IllegalStateException("No function defined with name=" + name);
    }

    public Function<Publisher<?>, Publisher<?>> getFunction() {
        return this.function;
    }

    public FunctionCatalog getCatalog() {
        return this.catalog;
    }

    public FunctionInspector getInspector() {
        return this.inspector;
    }
}

