/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.adapter.aws;

import com.amazonaws.services.lambda.runtime.serialization.PojoSerializer;
import com.amazonaws.services.lambda.runtime.serialization.events.LambdaEventSerializers;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.springframework.cloud.function.cloudevent.CloudEventMessageUtils;
import org.springframework.cloud.function.context.config.JsonMessageConverter;
import org.springframework.cloud.function.json.JsonMapper;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.util.MimeType;

class AWSTypesMessageConverter
extends JsonMessageConverter {
    private final JsonMapper jsonMapper;

    AWSTypesMessageConverter(JsonMapper jsonMapper) {
        this(jsonMapper, new MimeType("application", "json"), new MimeType(CloudEventMessageUtils.APPLICATION_CLOUDEVENTS.getType(), CloudEventMessageUtils.APPLICATION_CLOUDEVENTS.getSubtype() + "+json"));
    }

    AWSTypesMessageConverter(JsonMapper jsonMapper, MimeType ... supportedMimeTypes) {
        super(jsonMapper, supportedMimeTypes);
        this.jsonMapper = jsonMapper;
    }

    protected boolean canConvertFrom(Message<?> message, @Nullable Class<?> targetClass) {
        if (message.getHeaders().containsKey((Object)"aws-api-gateway")) {
            return (Boolean)message.getHeaders().get((Object)"aws-api-gateway");
        }
        if (message.getHeaders().containsKey((Object)"aws-event")) {
            return (Boolean)message.getHeaders().get((Object)"aws-event");
        }
        return targetClass.getPackage().getName().startsWith("com.amazonaws.services.lambda.runtime.events");
    }

    protected Object convertFromInternal(Message<?> message, Class<?> targetClass, @Nullable Object conversionHint) {
        if (message.getPayload().getClass().isAssignableFrom(targetClass)) {
            return message.getPayload();
        }
        if (targetClass.getPackage().getName().startsWith("com.amazonaws.services.lambda.runtime.events")) {
            PojoSerializer serializer = LambdaEventSerializers.serializerFor(targetClass, (ClassLoader)Thread.currentThread().getContextClassLoader());
            Object event = serializer.fromJson((InputStream)new ByteArrayInputStream((byte[])message.getPayload()));
            return event;
        }
        Map structMessage = (Map)this.jsonMapper.fromJson(message.getPayload(), Map.class);
        if (targetClass.isAssignableFrom(Map.class)) {
            return structMessage;
        }
        Object body = message.getHeaders().containsKey((Object)"payload") ? message.getPayload() : structMessage.get("body");
        Object convertedResult = this.jsonMapper.fromJson(body, targetClass);
        return convertedResult;
    }

    protected boolean canConvertTo(Object payload, @Nullable MessageHeaders headers) {
        return this.supportsMimeType(headers);
    }

    protected Object convertToInternal(Object payload, @Nullable MessageHeaders headers, @Nullable Object conversionHint) {
        if (payload instanceof String && headers.containsKey((Object)"isBase64Encoded") && ((Boolean)headers.get((Object)"isBase64Encoded")).booleanValue()) {
            return ((String)payload).getBytes(StandardCharsets.UTF_8);
        }
        return this.jsonMapper.toJson(payload);
    }
}

