/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.adapter.test.aws;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.web.servlet.context.ServletWebServerApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.MimeTypeUtils;

@EnableAutoConfiguration
public class AWSCustomRuntime {
    BlockingQueue<Object> inputQueue = new ArrayBlockingQueue<Object>(3);
    BlockingQueue<Message<String>> outputQueue = new ArrayBlockingQueue<Message<String>>(3);

    public AWSCustomRuntime(ServletWebServerApplicationContext context) {
        int port = context.getWebServer().getPort();
        System.setProperty("AWS_LAMBDA_RUNTIME_API", "localhost:" + port);
    }

    @Bean(value={"2018-06-01/runtime/invocation/consume/response"})
    Consumer<Message<String>> consume() {
        return v -> this.outputQueue.offer((Message<String>)v);
    }

    @Bean(value={"2018-06-01/runtime/invocation/next"})
    Supplier<Message<String>> supply() {
        return () -> {
            try {
                Object value = this.inputQueue.poll(Long.MAX_VALUE, TimeUnit.SECONDS);
                if (!(value instanceof Message)) {
                    return MessageBuilder.withPayload((Object)((String)value)).setHeader("Lambda-Runtime-Aws-Request-Id", (Object)"consume").setHeader("Content-Type", (Object)MimeTypeUtils.APPLICATION_JSON).build();
                }
                return (Message)value;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException(e);
            }
        };
    }

    public Message<String> exchange(Object input) {
        this.inputQueue.offer(input);
        try {
            return this.outputQueue.poll(5000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
    }
}

