/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.adapter.aws;

import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.function.adapter.aws.LambdaDestinationResolver;
import org.springframework.cloud.function.web.source.DestinationResolver;
import org.springframework.cloud.function.web.source.FunctionExporterAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureBefore(value={FunctionExporterAutoConfiguration.class})
@ConditionalOnClass(value={DestinationResolver.class})
@ConditionalOnProperty(prefix="spring.cloud.function.web.export", name={"enabled"}, matchIfMissing=false)
public class CustomRuntimeAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public DestinationResolver destinationResolver() {
        return new LambdaDestinationResolver();
    }

    @Bean
    public CommandLineRunner backgrounder() {
        return args -> CustomRuntimeAutoConfiguration.background();
    }

    static void background() {
        Thread thread = new Thread(() -> {
            System.out.println("Started");
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(500L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        });
        thread.setDaemon(false);
        thread.start();
    }
}

