/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.adapter.aws;

import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.RequestStreamHandler;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.boot.SpringApplication;
import org.springframework.cloud.function.adapter.aws.AWSLambdaUtils;
import org.springframework.cloud.function.context.FunctionCatalog;
import org.springframework.cloud.function.context.catalog.SimpleFunctionRegistry;
import org.springframework.cloud.function.utils.FunctionClassUtils;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StreamUtils;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;

public class FunctionInvoker
implements RequestStreamHandler {
    private static Log logger = LogFactory.getLog(FunctionInvoker.class);
    private ObjectMapper objectMapper;
    private SimpleFunctionRegistry.FunctionInvocationWrapper function;

    public FunctionInvoker() {
        this.start();
    }

    public void handleRequest(InputStream input, OutputStream output, Context context) throws IOException {
        byte[] payload = StreamUtils.copyToByteArray((InputStream)input);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Received: " + new String(payload, StandardCharsets.UTF_8)));
        }
        Message<byte[]> requestMessage = AWSLambdaUtils.generateMessage(payload, new MessageHeaders(Collections.emptyMap()), this.function.getInputType(), this.objectMapper, context);
        Object response = this.function.apply(requestMessage);
        byte[] responseBytes = this.buildResult(requestMessage, response);
        StreamUtils.copy((byte[])responseBytes, (OutputStream)output);
    }

    private byte[] buildResult(Message<?> requestMessage, Object output) throws IOException {
        Message responseMessage;
        if (output instanceof Publisher) {
            ArrayList result = new ArrayList();
            for (Object value : Flux.from((Publisher)((Publisher)output)).toIterable()) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Response value: " + value));
                }
                result.add(value);
            }
            output = result.size() > 1 ? result : result.get(0);
            if (logger.isInfoEnabled()) {
                logger.info((Object)("OUTPUT: " + output + " - " + output.getClass().getName()));
            }
            byte[] payload = this.objectMapper.writeValueAsBytes(output);
            responseMessage = MessageBuilder.withPayload((Object)payload).build();
        } else {
            responseMessage = (Message)output;
        }
        return AWSLambdaUtils.generateOutput(requestMessage, (Message<byte[]>)responseMessage, this.objectMapper);
    }

    private void start() {
        ConfigurableApplicationContext context = SpringApplication.run((Class)FunctionClassUtils.getStartClass(), (String[])new String[]{"--spring.main.web-application-type=none"});
        ConfigurableEnvironment environment = context.getEnvironment();
        String functionName = environment.getProperty("spring.cloud.function.definition");
        FunctionCatalog functionCatalog = (FunctionCatalog)context.getBean(FunctionCatalog.class);
        this.objectMapper = (ObjectMapper)context.getBean(ObjectMapper.class);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Locating function: '" + functionName + "'"));
        }
        this.function = (SimpleFunctionRegistry.FunctionInvocationWrapper)functionCatalog.lookup(functionName, new String[]{"application/json"});
        if (this.function == null && !CollectionUtils.isEmpty((Collection)functionCatalog.getNames(null))) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)"More then one function is available in FunctionCatalog. Will default to RoutingFunction, expecting 'spring.cloud.function.definition' or 'spring.cloud.function.routing-expression' as Message headers. If invocation is over API Gateway, Message headers can be provided as HTTP headers.");
            }
            this.function = (SimpleFunctionRegistry.FunctionInvocationWrapper)functionCatalog.lookup("functionRouter", new String[]{"application/json"});
        }
        if (this.function.isOutputTypePublisher()) {
            this.function.setSkipOutputConversion(true);
        }
        Assert.notNull((Object)this.function, (String)("Failed to lookup function " + functionName));
        if (!StringUtils.hasText((String)functionName)) {
            functionName = this.function.getFunctionDefinition();
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Located function: '" + functionName + "'"));
        }
    }
}

