/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.adapter.aws;

import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.RequestStreamHandler;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.cloud.function.adapter.aws.AWSLambdaUtils;
import org.springframework.cloud.function.context.FunctionCatalog;
import org.springframework.cloud.function.context.catalog.SimpleFunctionRegistry;
import org.springframework.cloud.function.utils.FunctionClassUtils;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.util.Assert;
import org.springframework.util.StreamUtils;
import org.springframework.util.StringUtils;

public class FunctionInvoker
implements RequestStreamHandler {
    private static Log logger = LogFactory.getLog(FunctionInvoker.class);
    private ObjectMapper objectMapper;
    private SimpleFunctionRegistry.FunctionInvocationWrapper function;

    public FunctionInvoker() {
        this.start();
    }

    public void handleRequest(InputStream input, OutputStream output, Context context) throws IOException {
        byte[] payload = StreamUtils.copyToByteArray((InputStream)input);
        Message<byte[]> requestMessage = AWSLambdaUtils.generateMessage(payload, new MessageHeaders(Collections.emptyMap()), this.function.getInputType(), this.objectMapper, context);
        Message responseMessage = (Message)this.function.apply(requestMessage);
        byte[] responseBytes = AWSLambdaUtils.generateOutput(requestMessage, (Message<byte[]>)responseMessage, this.objectMapper);
        StreamUtils.copy((byte[])responseBytes, (OutputStream)output);
    }

    private void start() {
        ConfigurableApplicationContext context = SpringApplication.run((Class)FunctionClassUtils.getStartClass(), (String[])new String[0]);
        ConfigurableEnvironment environment = context.getEnvironment();
        String functionName = environment.getProperty("spring.cloud.function.definition");
        FunctionCatalog functionCatalog = (FunctionCatalog)context.getBean(FunctionCatalog.class);
        this.objectMapper = (ObjectMapper)context.getBean(ObjectMapper.class);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Locating function: '" + functionName + "'"));
        }
        this.function = (SimpleFunctionRegistry.FunctionInvocationWrapper)functionCatalog.lookup(functionName, new String[]{"application/json"});
        Assert.notNull((Object)this.function, (String)("Failed to lookup function " + functionName));
        if (!StringUtils.hasText((String)functionName)) {
            functionName = this.function.getFunctionDefinition();
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Located function: '" + functionName + "'"));
        }
    }

    private void configureObjectMapper() {
        SimpleModule module = new SimpleModule();
        module.addDeserializer(Date.class, (JsonDeserializer)new JsonDeserializer<Date>(){

            public Date deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeInMillis(jsonParser.getValueAsLong());
                return calendar.getTime();
            }
        });
        this.objectMapper.registerModule((Module)module);
        this.objectMapper.registerModule((Module)new JodaModule());
        this.objectMapper.configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true);
    }
}

