/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.test;

import org.hamcrest.Description;
import org.hamcrest.DiagnosingMatcher;
import org.hamcrest.Matcher;

public class EventuallyMatcher<U>
extends DiagnosingMatcher<U> {
    private final Matcher<U> delegate;
    private int maxAttempts;
    private int pause;

    public EventuallyMatcher(Matcher<U> delegate) {
        this(delegate, 20, 100);
    }

    public EventuallyMatcher(Matcher<U> delegate, int maxAttempts, int pause) {
        this.delegate = delegate;
        this.maxAttempts = maxAttempts;
        this.pause = pause;
    }

    public void describeTo(Description description) {
        description.appendDescriptionOf(this.delegate).appendText(String.format(", trying at most %d times", this.maxAttempts));
    }

    protected boolean matches(Object item, Description mismatchDescription) {
        mismatchDescription.appendText(String.format("failed after %d*%d=%dms:%n", this.maxAttempts, this.pause, this.maxAttempts * this.pause));
        for (int i = 0; i < this.maxAttempts; ++i) {
            boolean result = this.delegate.matches(item);
            if (result) {
                return true;
            }
            this.delegate.describeMismatch(item, mismatchDescription);
            mismatchDescription.appendText(", ");
            try {
                Thread.sleep(this.pause);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        }
        return false;
    }

    public static <T> EventuallyMatcher<T> eventually(Matcher<T> delegate) {
        return new EventuallyMatcher<T>(delegate);
    }

    public static <T> EventuallyMatcher<T> eventually(Matcher<T> delegate, int noAttempts, int pause) {
        return new EventuallyMatcher<T>(delegate, noAttempts, pause);
    }
}

