/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.test.app;

import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.deployer.spi.test.app.DeployerIntegrationTestProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.Assert;

@EnableConfigurationProperties(value={DeployerIntegrationTestProperties.class})
@Configuration
public class DeployerIntegrationTest {
    @Autowired
    private DeployerIntegrationTestProperties properties;

    @PostConstruct
    public void init() throws InterruptedException {
        String parameterThatMayNeedEscaping = this.properties.getParameterThatMayNeedEscaping();
        if (parameterThatMayNeedEscaping != null && !"&'\"|< \u00e9\\(".equals(parameterThatMayNeedEscaping)) {
            throw new IllegalArgumentException(String.format("Expected 'parameterThatMayNeedEscaping' value to be equal to '%s', but was '%s'", "&'\"|< \u00e9\\(", parameterThatMayNeedEscaping));
        }
        String commandLineArgValueThatMayNeedEscaping = this.properties.getCommandLineArgValueThatMayNeedEscaping();
        if (commandLineArgValueThatMayNeedEscaping != null && !"&'\"|< \u00e9\\(".equals(commandLineArgValueThatMayNeedEscaping)) {
            throw new IllegalArgumentException(String.format("Expected 'commandLineArgValueThatMayNeedEscaping' value to be equal to '%s', but was '%s'", "&'\"|< \u00e9\\(", commandLineArgValueThatMayNeedEscaping));
        }
        Assert.notNull((Object)this.properties.getInstanceIndex(), (String)"instanceIndex should have been set by deployer or runtime");
        if (this.properties.getMatchInstances().isEmpty() || this.properties.getMatchInstances().contains(this.properties.getInstanceIndex())) {
            System.out.format("Waiting for %dms before allowing further initialization and actuator startup...", this.properties.getInitDelay());
            Thread.sleep(this.properties.getInitDelay());
            System.out.println("... done");
            if (this.properties.getKillDelay() >= 0) {
                System.out.format("Will kill this process in %dms%n", this.properties.getKillDelay());
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(DeployerIntegrationTest.this.properties.getKillDelay());
                            System.exit(DeployerIntegrationTest.this.properties.getExitCode());
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }.start();
            }
        }
    }
}

