/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.resource.maven;

import org.eclipse.aether.AbstractRepositoryListener;
import org.eclipse.aether.RepositoryEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingRepositoryListener
extends AbstractRepositoryListener {
    private static final Logger log = LoggerFactory.getLogger(LoggingRepositoryListener.class);

    public void artifactDeployed(RepositoryEvent event) {
        this.println("artifactDeployed", event.getArtifact() + " to " + event.getRepository());
    }

    public void artifactDeploying(RepositoryEvent event) {
        this.println("artifactDeploying", event.getArtifact() + " to " + event.getRepository());
    }

    public void artifactDescriptorInvalid(RepositoryEvent event) {
        this.println("artifactDescriptorInvalid", "for " + event.getArtifact() + ": " + event.getException().getMessage());
    }

    public void artifactDescriptorMissing(RepositoryEvent event) {
        this.println("artifactDescriptorMissing", "for " + event.getArtifact());
    }

    public void artifactInstalled(RepositoryEvent event) {
        this.println("artifactInstalled", event.getArtifact() + " to " + event.getFile());
    }

    public void artifactInstalling(RepositoryEvent event) {
        this.println("artifactInstalling", event.getArtifact() + " to " + event.getFile());
    }

    public void artifactResolved(RepositoryEvent event) {
        this.println("artifactResolved", event.getArtifact() + " from " + event.getRepository());
    }

    public void artifactDownloading(RepositoryEvent event) {
        this.println("artifactDownloading", event.getArtifact() + " from " + event.getRepository());
    }

    public void artifactDownloaded(RepositoryEvent event) {
        this.println("artifactDownloaded", event.getArtifact() + " from " + event.getRepository());
    }

    public void artifactResolving(RepositoryEvent event) {
        this.println("artifactResolving", event.getArtifact().toString());
    }

    public void metadataDeployed(RepositoryEvent event) {
        this.println("metadataDeployed", event.getMetadata() + " to " + event.getRepository());
    }

    public void metadataDeploying(RepositoryEvent event) {
        this.println("metadataDeploying", event.getMetadata() + " to " + event.getRepository());
    }

    public void metadataInstalled(RepositoryEvent event) {
        this.println("metadataInstalled", event.getMetadata() + " to " + event.getFile());
    }

    public void metadataInstalling(RepositoryEvent event) {
        this.println("metadataInstalling", event.getMetadata() + " to " + event.getFile());
    }

    public void metadataInvalid(RepositoryEvent event) {
        this.println("metadataInvalid", event.getMetadata().toString());
    }

    public void metadataResolved(RepositoryEvent event) {
        this.println("metadataResolved", event.getMetadata() + " from " + event.getRepository());
    }

    public void metadataResolving(RepositoryEvent event) {
        this.println("metadataResolving", event.getMetadata() + " from " + event.getRepository());
    }

    private void println(String event, String message) {
        log.info("Aether Repository - " + event + ": " + message);
    }
}

