/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.mesos.marathon;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import mesosphere.marathon.client.Marathon;
import mesosphere.marathon.client.model.v2.App;
import mesosphere.marathon.client.model.v2.Container;
import mesosphere.marathon.client.model.v2.Docker;
import mesosphere.marathon.client.model.v2.HealthCheck;
import mesosphere.marathon.client.model.v2.Port;
import mesosphere.marathon.client.model.v2.Task;
import mesosphere.marathon.client.utils.MarathonException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.deployer.spi.app.AppDeployer;
import org.springframework.cloud.deployer.spi.app.AppInstanceStatus;
import org.springframework.cloud.deployer.spi.app.AppStatus;
import org.springframework.cloud.deployer.spi.app.DeploymentState;
import org.springframework.cloud.deployer.spi.core.AppDeploymentRequest;
import org.springframework.cloud.deployer.spi.mesos.marathon.MarathonAppDeployerProperties;
import org.springframework.cloud.deployer.spi.mesos.marathon.MarathonAppInstanceStatus;
import org.springframework.util.Assert;

public class MarathonAppDeployer
implements AppDeployer {
    private static final Logger logger = LoggerFactory.getLogger(MarathonAppDeployer.class);
    private MarathonAppDeployerProperties properties = new MarathonAppDeployerProperties();
    Marathon marathon;

    @Autowired
    public MarathonAppDeployer(MarathonAppDeployerProperties properties, Marathon marathon) {
        this.properties = properties;
        this.marathon = marathon;
    }

    public String deploy(AppDeploymentRequest request) {
        logger.info("Deploying app: {}", (Object)request.getDefinition().getName());
        String appId = this.deduceAppId(request);
        AppStatus status = this.status(appId);
        if (!status.getState().equals((Object)DeploymentState.unknown)) {
            throw new IllegalStateException(String.format("App '%s' is already deployed", request.getDefinition().getName()));
        }
        Container container = new Container();
        Docker docker = new Docker();
        String image = null;
        try {
            image = request.getResource().getURI().getSchemeSpecificPart();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to get URI for " + request.getResource(), e);
        }
        logger.info("Using Docker image: " + image);
        docker.setImage(image);
        Port port = new Port(Integer.valueOf(8080));
        port.setHostPort(Integer.valueOf(0));
        docker.setPortMappings(Arrays.asList(port));
        docker.setNetwork("BRIDGE");
        container.setDocker(docker);
        App app = new App();
        app.setContainer(container);
        app.setId(appId);
        HashMap<String, String> env = new HashMap<String, String>();
        env.putAll(request.getDefinition().getProperties());
        env.putAll(request.getDeploymentProperties());
        for (String envVar : this.properties.getEnvironmentVariables()) {
            String[] strings = envVar.split("=", 2);
            Assert.isTrue((strings.length == 2 ? 1 : 0) != 0, (String)("Invalid environment variable declared: " + envVar));
            env.put(strings[0], strings[1]);
        }
        app.setEnv(env);
        Double cpus = this.deduceCpus(request);
        Double memory = this.deduceMemory(request);
        app.setCpus(cpus);
        app.setMem(memory);
        app.setInstances(Integer.getInteger((String)request.getDefinition().getProperties().get("spring.cloud.deployer.count")));
        HealthCheck healthCheck = new HealthCheck();
        healthCheck.setPath("/health");
        healthCheck.setGracePeriodSeconds(Integer.valueOf(300));
        app.setHealthChecks(Arrays.asList(healthCheck));
        logger.debug("Creating app with definition: " + app.toString());
        try {
            this.marathon.createApp(app);
        }
        catch (MarathonException e) {
            throw new RuntimeException(e);
        }
        return app.getId();
    }

    public void undeploy(String id) {
        logger.info("Undeploying module: {}", (Object)id);
        try {
            this.marathon.deleteApp(id);
        }
        catch (MarathonException e) {
            throw new RuntimeException(e);
        }
    }

    public AppStatus status(String id) {
        AppStatus status;
        try {
            App app = this.marathon.getApp(id).getApp();
            status = this.buildStatus(id, app);
        }
        catch (MarathonException e) {
            if (e.getMessage().contains("Not Found")) {
                status = AppStatus.of((String)id).build();
            }
            throw new RuntimeException(e);
        }
        logger.debug("Status for app: {} is {}", (Object)id, (Object)status);
        return status;
    }

    private String deduceAppId(AppDeploymentRequest request) {
        String groupId = (String)request.getDeploymentProperties().get("spring.cloud.deployer.group");
        String name = request.getDefinition().getName();
        if (groupId != null) {
            return groupId + "-" + name;
        }
        return name;
    }

    private Double deduceMemory(AppDeploymentRequest request) {
        String override = (String)request.getDeploymentProperties().get("spring.cloud.deployer.marathon.memory");
        return override != null ? Double.valueOf(override).doubleValue() : this.properties.getMemory();
    }

    private Double deduceCpus(AppDeploymentRequest request) {
        String override = (String)request.getDeploymentProperties().get("spring.cloud.deployer.marathon.cpu");
        return override != null ? Double.valueOf(override).doubleValue() : this.properties.getCpu();
    }

    private AppStatus buildStatus(String id, App app) {
        logger.debug("App " + id + " has " + app.getTasksRunning() + "/" + app.getInstances() + " tasks running");
        AppStatus.Builder result = AppStatus.of((String)id);
        int requestedInstances = app.getInstances();
        int actualInstances = 0;
        if (app.getTasks() != null) {
            for (Task task : app.getTasks()) {
                result.with((AppInstanceStatus)MarathonAppInstanceStatus.up(app, task));
                ++actualInstances;
            }
        }
        for (int i = actualInstances; i < requestedInstances; ++i) {
            result.with((AppInstanceStatus)MarathonAppInstanceStatus.down(app));
        }
        return result.build();
    }
}

