/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.local;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.Inet4Address;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.deployer.spi.app.AppDeployer;
import org.springframework.cloud.deployer.spi.app.AppInstanceStatus;
import org.springframework.cloud.deployer.spi.app.AppStatus;
import org.springframework.cloud.deployer.spi.app.DeploymentState;
import org.springframework.cloud.deployer.spi.core.AppDeploymentRequest;
import org.springframework.cloud.deployer.spi.core.RuntimeEnvironmentInfo;
import org.springframework.cloud.deployer.spi.local.AbstractLocalDeployerSupport;
import org.springframework.cloud.deployer.spi.local.LocalDeployerProperties;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StringUtils;

public class LocalAppDeployer
extends AbstractLocalDeployerSupport
implements AppDeployer {
    private static final Logger logger = LoggerFactory.getLogger(LocalAppDeployer.class);
    private static final String JMX_DEFAULT_DOMAIN_KEY = "spring.jmx.default-domain";
    private static final String ENDPOINTS_SHUTDOWN_ENABLED_KEY = "endpoints.shutdown.enabled";
    private final Map<String, List<AppInstance>> running = new ConcurrentHashMap<String, List<AppInstance>>();
    private Path logPathRoot;

    public LocalAppDeployer(LocalDeployerProperties properties) {
        super(properties);
        try {
            this.logPathRoot = Files.createTempDirectory(properties.getWorkingDirectoriesRoot(), "spring-cloud-deployer-", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create workdir root: " + properties.getWorkingDirectoriesRoot(), e);
        }
    }

    private static Integer getProcessExitValue(Process process) {
        try {
            return process.exitValue();
        }
        catch (IllegalThreadStateException e) {
            return null;
        }
    }

    private static synchronized int getLocalProcessPid(Process p) {
        int pid = 0;
        try {
            if (p.getClass().getName().equals("java.lang.UNIXProcess")) {
                Field f = p.getClass().getDeclaredField("pid");
                f.setAccessible(true);
                pid = f.getInt(p);
                f.setAccessible(false);
            }
        }
        catch (Exception e) {
            pid = 0;
        }
        return pid;
    }

    public String deploy(AppDeploymentRequest request) {
        String group = (String)request.getDeploymentProperties().get("spring.cloud.deployer.group");
        String deploymentId = String.format("%s.%s", group, request.getDefinition().getName());
        this.validateStatus(deploymentId);
        ArrayList<AppInstance> processes = new ArrayList<AppInstance>();
        this.running.put(deploymentId, processes);
        boolean useDynamicPort = !request.getDefinition().getProperties().containsKey("server.port");
        HashMap<String, String> consolidatedAppProperties = new HashMap<String, String>(request.getDefinition().getProperties());
        consolidatedAppProperties.put(JMX_DEFAULT_DOMAIN_KEY, deploymentId);
        if (!request.getDefinition().getProperties().containsKey(ENDPOINTS_SHUTDOWN_ENABLED_KEY)) {
            consolidatedAppProperties.put(ENDPOINTS_SHUTDOWN_ENABLED_KEY, "true");
        }
        consolidatedAppProperties.put("endpoints.jmx.unique-names", "true");
        if (group != null) {
            consolidatedAppProperties.put("spring.cloud.application.group", group);
        }
        try {
            Path deploymentGroupDir = this.createLogDir(group);
            Path workDir = this.createWorkingDir(deploymentId, deploymentGroupDir);
            String countProperty = (String)request.getDeploymentProperties().get("spring.cloud.deployer.count");
            int count = StringUtils.hasText((String)countProperty) ? Integer.parseInt(countProperty) : 1;
            for (int i = 0; i < count; ++i) {
                HashMap<String, String> appInstanceEnv = new HashMap<String, String>(consolidatedAppProperties);
                int port = this.calcServerPort(request, useDynamicPort, appInstanceEnv);
                if (this.useSpringApplicationJson(request)) {
                    appInstanceEnv.put("instance.index", Integer.toString(i));
                    appInstanceEnv.put("spring.cloud.stream.instanceIndex", Integer.toString(i));
                    appInstanceEnv.put("spring.application.index", Integer.toString(i));
                    appInstanceEnv.put("spring.cloud.application.guid", Integer.toString(port));
                } else {
                    appInstanceEnv.put("INSTANCE_INDEX", Integer.toString(i));
                    appInstanceEnv.put("SPRING_APPLICATION_INDEX", Integer.toString(i));
                    appInstanceEnv.put("SPRING_CLOUD_APPLICATION_GUID", Integer.toString(port));
                }
                if (this.useSpringApplicationJson(request)) {
                    appInstanceEnv.put("instance.index", Integer.toString(i));
                    appInstanceEnv.put("spring.application.index", Integer.toString(i));
                    appInstanceEnv.put("spring.cloud.application.guid", Integer.toString(port));
                }
                AppInstance instance = new AppInstance(deploymentId, i, port);
                ProcessBuilder builder = this.buildProcessBuilder(request, appInstanceEnv, Optional.of(i), deploymentId).inheritIO();
                builder.directory(workDir.toFile());
                if (this.shouldInheritLogging(request)) {
                    instance.start(builder, workDir);
                    logger.info("Deploying app with deploymentId {} instance {}.\n   Logs will be inherited.", (Object)deploymentId, (Object)i);
                } else {
                    instance.start(builder, workDir, this.getLocalDeployerProperties().isDeleteFilesOnExit());
                    logger.info("Deploying app with deploymentId {} instance {}.\n   Logs will be in {}", new Object[]{deploymentId, i, workDir});
                }
                processes.add(instance);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Exception trying to deploy " + request, e);
        }
        return deploymentId;
    }

    public void undeploy(String id) {
        List<AppInstance> processes = this.running.get(id);
        if (processes != null) {
            for (AppInstance instance : processes) {
                if (!this.isAlive(instance.getProcess())) continue;
                logger.info("Un-deploying app with deploymentId {} instance {}.", (Object)id, (Object)instance.getInstanceNumber());
                this.shutdownAndWait(instance);
            }
        } else {
            throw new IllegalStateException(String.format("App with deploymentId %s is not in a deployed state.", id));
        }
        this.running.remove(id);
    }

    public AppStatus status(String id) {
        List<AppInstance> instances = this.running.get(id);
        AppStatus.Builder builder = AppStatus.of((String)id);
        if (instances != null) {
            for (AppInstance instance : instances) {
                builder.with((AppInstanceStatus)instance);
            }
        }
        return builder.build();
    }

    public String getLog(String id) {
        List<AppInstance> instances = this.running.get(id);
        StringBuilder stringBuilder = new StringBuilder();
        if (instances != null) {
            for (AppInstance instance : instances) {
                String stderr = instance.getStdErr();
                if (StringUtils.hasText((String)stderr)) {
                    stringBuilder.append(stderr);
                    continue;
                }
                stringBuilder.append(instance.getStdOut());
            }
        }
        return stringBuilder.toString();
    }

    public RuntimeEnvironmentInfo environmentInfo() {
        return super.createRuntimeEnvironmentInfo(AppDeployer.class, this.getClass());
    }

    @PreDestroy
    public void shutdown() throws Exception {
        for (String deploymentId : this.running.keySet()) {
            this.undeploy(deploymentId);
        }
    }

    private Path createWorkingDir(String deploymentId, Path deploymentGroupDir) throws IOException {
        Path workDir = Files.createDirectory(Paths.get(deploymentGroupDir.toFile().getAbsolutePath(), deploymentId), new FileAttribute[0]);
        if (this.getLocalDeployerProperties().isDeleteFilesOnExit()) {
            workDir.toFile().deleteOnExit();
        }
        return workDir;
    }

    private Path createLogDir(String group) throws IOException {
        Path deploymentGroupDir = Paths.get(this.logPathRoot.toFile().getAbsolutePath(), group + "-" + System.currentTimeMillis());
        if (!Files.exists(deploymentGroupDir, new LinkOption[0])) {
            Files.createDirectory(deploymentGroupDir, new FileAttribute[0]);
            deploymentGroupDir.toFile().deleteOnExit();
        }
        return deploymentGroupDir;
    }

    private void validateStatus(String deploymentId) {
        DeploymentState state = this.status(deploymentId).getState();
        Assert.state((state == DeploymentState.unknown ? 1 : 0) != 0, (String)String.format("App with deploymentId [%s] is already deployed with state [%s]", deploymentId, state));
    }

    private static class AppInstance
    implements AbstractLocalDeployerSupport.Instance,
    AppInstanceStatus {
        private final String deploymentId;
        private final int instanceNumber;
        private final URL baseUrl;
        private final Map<String, String> attributes = new TreeMap<String, String>();
        private int pid;
        private Process process;
        private File workFile;
        private File stdout;
        private File stderr;
        private int port;

        private AppInstance(String deploymentId, int instanceNumber, int port) throws IOException {
            this.deploymentId = deploymentId;
            this.instanceNumber = instanceNumber;
            this.port = port;
            this.attributes.put("port", Integer.toString(port));
            this.attributes.put("guid", Integer.toString(port));
            this.baseUrl = new URL("http", Inet4Address.getLocalHost().getHostAddress(), port, "");
            this.attributes.put("url", this.baseUrl.toString());
        }

        public String getId() {
            return this.deploymentId + "-" + this.instanceNumber;
        }

        @Override
        public URL getBaseUrl() {
            return this.baseUrl;
        }

        @Override
        public Process getProcess() {
            return this.process;
        }

        public String toString() {
            return String.format("%s [%s]", this.getId(), this.getState());
        }

        public DeploymentState getState() {
            Integer exit = LocalAppDeployer.getProcessExitValue(this.process);
            if (exit != null) {
                return DeploymentState.failed;
            }
            if (this.port < 1) {
                return DeploymentState.deployed;
            }
            try {
                HttpURLConnection urlConnection = (HttpURLConnection)this.baseUrl.openConnection();
                urlConnection.setConnectTimeout(100);
                urlConnection.connect();
                urlConnection.disconnect();
                return DeploymentState.deployed;
            }
            catch (IOException e) {
                return DeploymentState.deploying;
            }
        }

        public String getStdOut() {
            try {
                return FileCopyUtils.copyToString((Reader)new InputStreamReader(new FileInputStream(this.stdout)));
            }
            catch (IOException e) {
                return "Log retrieval returned " + e.getMessage();
            }
        }

        public String getStdErr() {
            try {
                return FileCopyUtils.copyToString((Reader)new InputStreamReader(new FileInputStream(this.stderr)));
            }
            catch (IOException e) {
                return "Log retrieval returned " + e.getMessage();
            }
        }

        public int getInstanceNumber() {
            return this.instanceNumber;
        }

        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        private void start(ProcessBuilder builder, Path workDir) throws IOException {
            if (logger.isDebugEnabled()) {
                logger.debug("Local App Deployer Commands: " + String.join((CharSequence)",", builder.command()) + ", Environment: " + builder.environment());
            }
            this.workFile = workDir.toFile();
            this.attributes.put("working.dir", this.workFile.getAbsolutePath());
            this.process = builder.start();
            this.pid = LocalAppDeployer.getLocalProcessPid(this.process);
            if (this.pid > 0) {
                this.attributes.put("pid", Integer.toString(this.pid));
            }
        }

        private void start(ProcessBuilder builder, Path workDir, boolean deleteOnExit) throws IOException {
            String workDirPath = workDir.toFile().getAbsolutePath();
            this.stdout = Files.createFile(Paths.get(workDirPath, "stdout_" + this.instanceNumber + ".log"), new FileAttribute[0]).toFile();
            this.attributes.put("stdout", this.stdout.getAbsolutePath());
            this.stderr = Files.createFile(Paths.get(workDirPath, "stderr_" + this.instanceNumber + ".log"), new FileAttribute[0]).toFile();
            this.attributes.put("stderr", this.stderr.getAbsolutePath());
            if (deleteOnExit) {
                this.stdout.deleteOnExit();
                this.stderr.deleteOnExit();
            }
            builder.redirectOutput(ProcessBuilder.Redirect.to(this.stdout));
            builder.redirectError(ProcessBuilder.Redirect.to(this.stderr));
            this.start(builder, workDir);
        }
    }
}

