/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.local;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.deployer.resource.docker.DockerResource;
import org.springframework.cloud.deployer.spi.core.AppDeploymentRequest;
import org.springframework.cloud.deployer.spi.core.RuntimeEnvironmentInfo;
import org.springframework.cloud.deployer.spi.local.DockerCommandBuilder;
import org.springframework.cloud.deployer.spi.local.JavaCommandBuilder;
import org.springframework.cloud.deployer.spi.local.LocalDeployerProperties;
import org.springframework.cloud.deployer.spi.local.LocalDeployerUtils;
import org.springframework.cloud.deployer.spi.util.RuntimeVersionUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.web.client.RestTemplate;

public abstract class AbstractLocalDeployerSupport {
    public static final String USE_SPRING_APPLICATION_JSON_KEY = "spring.cloud.deployer.local.use-spring-application-json";
    public static final String SPRING_APPLICATION_JSON = "SPRING_APPLICATION_JSON";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final LocalDeployerProperties properties;
    private final RestTemplate restTemplate = new RestTemplate();
    private final JavaCommandBuilder javaCommandBuilder;
    private final DockerCommandBuilder dockerCommandBuilder;
    private String[] envVarsSetByDeployer = new String[]{"SPRING_CLOUD_APPLICATION_GUID", "SPRING_APPLICATION_INDEX", "INSTANCE_INDEX"};

    public AbstractLocalDeployerSupport(LocalDeployerProperties properties) {
        Assert.notNull((Object)properties, (String)"LocalDeployerProperties must not be null");
        this.properties = properties;
        this.javaCommandBuilder = new JavaCommandBuilder(properties);
        this.dockerCommandBuilder = new DockerCommandBuilder();
    }

    protected String buildRemoteDebugInstruction(Map<String, String> deploymentProperties, String deploymentId, int instanceIndex, int port) {
        String ds = deploymentProperties.getOrDefault("spring.cloud.deployer.local.debugSuspend", "y");
        StringBuilder debugCommandBuilder = new StringBuilder();
        this.logger.warn("Deploying app with deploymentId {}, instance {}. Remote debugging is enabled on port {}.", new Object[]{deploymentId, instanceIndex, port});
        debugCommandBuilder.append("-agentlib:jdwp=transport=dt_socket,server=y,suspend=");
        debugCommandBuilder.append(ds.trim());
        debugCommandBuilder.append(",address=");
        debugCommandBuilder.append(port);
        String debugCommand = debugCommandBuilder.toString();
        this.logger.debug("Deploying app with deploymentId {}, instance {}.  Debug Command = [{}]", (Object)debugCommand);
        if (ds.equals("y")) {
            this.logger.warn("Deploying app with deploymentId {}.  Application Startup will be suspended until remote debugging session is established.");
        }
        return debugCommand;
    }

    protected RuntimeEnvironmentInfo createRuntimeEnvironmentInfo(Class<?> spiClass, Class<?> implementationClass) {
        return new RuntimeEnvironmentInfo.Builder().spiClass(spiClass).implementationName(implementationClass.getSimpleName()).implementationVersion(RuntimeVersionUtils.getVersion(implementationClass)).platformType("Local").platformApiVersion(System.getProperty("os.name") + " " + System.getProperty("os.version")).platformClientVersion(System.getProperty("os.version")).platformHostVersion(System.getProperty("os.version")).build();
    }

    protected final LocalDeployerProperties getLocalDeployerProperties() {
        return this.properties;
    }

    protected void retainEnvVars(Set<String> vars) {
        ArrayList<String> patterns = new ArrayList<String>(Arrays.asList(this.getLocalDeployerProperties().getEnvVarsToInherit()));
        patterns.addAll(Arrays.asList(this.envVarsSetByDeployer));
        Iterator<String> iterator = vars.iterator();
        while (iterator.hasNext()) {
            String var = iterator.next();
            boolean retain = false;
            for (String pattern : patterns) {
                if (!Pattern.matches(pattern, var)) continue;
                retain = true;
                break;
            }
            if (retain) continue;
            iterator.remove();
        }
    }

    protected ProcessBuilder buildProcessBuilder(AppDeploymentRequest request, Map<String, String> appInstanceEnv, Map<String, String> appProperties, Optional<Integer> appInstanceNumber, String deploymentId) {
        Assert.notNull((Object)request, (String)"AppDeploymentRequest must be set");
        Assert.notNull(appProperties, (String)"Args must be set");
        String[] commands = null;
        HashMap<String, String> appInstanceEnvToUse = new HashMap<String, String>(appInstanceEnv);
        HashMap<String, String> appPropertiesToUse = new HashMap<String, String>();
        this.handleAppPropertiesPassing(request, appProperties, appInstanceEnvToUse, appPropertiesToUse);
        commands = request.getResource() instanceof DockerResource ? this.dockerCommandBuilder.buildExecutionCommand(request, appInstanceEnvToUse, appPropertiesToUse, appInstanceNumber) : this.javaCommandBuilder.buildExecutionCommand(request, appInstanceEnvToUse, appPropertiesToUse, appInstanceNumber);
        if (LocalDeployerUtils.isWindows()) {
            for (int i = 0; i < commands.length; ++i) {
                commands[i] = commands[i].replace("\"", "\\\"");
            }
        }
        ProcessBuilder builder = new ProcessBuilder(commands);
        if (!(request.getResource() instanceof DockerResource)) {
            builder.environment().putAll(appInstanceEnv);
            builder.environment().putAll(appInstanceEnvToUse);
        }
        this.retainEnvVars(builder.environment().keySet());
        if (this.containsValidDebugPort(request.getDeploymentProperties(), deploymentId)) {
            int portToUse = this.calculateDebugPort(request.getDeploymentProperties(), appInstanceNumber.orElseGet(() -> 0));
            builder.command().add(1, this.buildRemoteDebugInstruction(request.getDeploymentProperties(), deploymentId, appInstanceNumber.orElseGet(() -> 0), portToUse));
        }
        return builder;
    }

    protected void handleAppPropertiesPassing(AppDeploymentRequest request, Map<String, String> appProperties, Map<String, String> appInstanceEnvToUse, Map<String, String> appPropertiesToUse) {
        if (this.useSpringApplicationJson(request)) {
            try {
                HashMap<String, String> localApplicationProperties = new HashMap<String, String>(appProperties);
                if (localApplicationProperties.containsKey(SPRING_APPLICATION_JSON)) {
                    localApplicationProperties.putAll((Map)OBJECT_MAPPER.readValue(appProperties.get(SPRING_APPLICATION_JSON), (TypeReference)new TypeReference<HashMap<String, Object>>(){}));
                    localApplicationProperties.remove(SPRING_APPLICATION_JSON);
                }
                appInstanceEnvToUse.putAll(Collections.singletonMap(SPRING_APPLICATION_JSON, OBJECT_MAPPER.writeValueAsString(localApplicationProperties)));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            appPropertiesToUse.putAll(appProperties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdownAndWait(Instance instance) {
        try {
            ResponseEntity response;
            int timeout = this.getLocalDeployerProperties().getShutdownTimeout();
            if (timeout > 0 && (response = this.restTemplate.postForEntity(instance.getBaseUrl() + "/shutdown", null, String.class, new Object[0])).getStatusCode().is2xxSuccessful()) {
                long timeoutTimestamp = System.currentTimeMillis() + (long)(timeout * 1000);
                while (AbstractLocalDeployerSupport.isAlive(instance.getProcess()) && System.currentTimeMillis() < timeoutTimestamp) {
                    Thread.sleep(1000L);
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception exception) {
        }
        finally {
            if (AbstractLocalDeployerSupport.isAlive(instance.getProcess())) {
                instance.getProcess().destroy();
            }
        }
    }

    protected static boolean isAlive(Process process) {
        try {
            process.exitValue();
            return false;
        }
        catch (IllegalThreadStateException e) {
            return true;
        }
    }

    protected boolean containsValidDebugPort(Map<String, String> deploymentProperties, String deploymentId) {
        boolean validDebugPort = false;
        if (deploymentProperties.containsKey("spring.cloud.deployer.local.debugPort")) {
            String basePort = deploymentProperties.get("spring.cloud.deployer.local.debugPort");
            try {
                int port = Integer.parseInt(basePort);
                if (port <= 0) {
                    this.logger.error("The debug port {} specified for deploymentId {} must be greater than zero");
                    return false;
                }
            }
            catch (NumberFormatException e) {
                this.logger.error("The debug port {} specified for deploymentId {} can not be parsed to an integer.", (Object)basePort, (Object)deploymentId);
                return false;
            }
            validDebugPort = true;
        }
        return validDebugPort;
    }

    protected int calculateDebugPort(Map<String, String> deploymentProperties, int instanceIndex) {
        String basePort = deploymentProperties.get("spring.cloud.deployer.local.debugPort");
        return Integer.parseInt(basePort) + instanceIndex;
    }

    private boolean useSpringApplicationJson(AppDeploymentRequest request) {
        return Optional.ofNullable(request.getDeploymentProperties().get(USE_SPRING_APPLICATION_JSON_KEY)).map(Boolean::valueOf).orElse(this.properties.isUseSpringApplicationJson());
    }

    protected static interface Instance {
        public URL getBaseUrl();

        public Process getProcess();
    }
}

